// Copyright 2025 Diffblue Limited. All Rights Reserved.
// Unpublished proprietary source code.
// Use is governed by https://docs.diffblue.com/licenses/eula

package com.diffblue.jersey.isolation;

import java.util.function.Function;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.test.JerseyTest;
import org.glassfish.jersey.test.inmemory.InMemoryTestContainerFactory;

/**
 * Test class for Jersey. Before the execution, we need to set the values of the static fields cls
 * and function. The test method will execute the function with the instance of the class.
 */
class DiffblueJersey2Test extends JerseyTest {
  public static Function<Object, Object> configureFunction;

  public DiffblueJersey2Test() {
    super(new InMemoryTestContainerFactory());
  }

  @Override
  protected Application configure() {
    return (Application) configureFunction.apply(this);
  }
}
