// Copyright 2021-2025 Diffblue Limited. All Rights Reserved.
// Unpublished proprietary source code.
// Use is governed by https://docs.diffblue.com/licenses/eula
import com.diffblue.cover.tir2jdt.internal.translation.TirToJavaVisitor;

/**
 * This file provides a helper method that will be inserted in the test class whenever the test
 * requires reading fields reflectively.
 *
 * @see TirToJavaVisitor#addHelperMethods(String)
 */
public class ReflectionHelperGetField {

  private static Object getField(Class<?> declaringClass, Object instance, String fieldName) {
    try {
      java.lang.reflect.Field field = declaringClass.getDeclaredField(fieldName);
      field.setAccessible(true);
      return field.get(instance);
    } catch (IllegalAccessException | NoSuchFieldException e) {
      throw new RuntimeException("Unable to reflectively read field '" + fieldName + "'", e);
    }
  }
}
