// Copyright 2021-2025 Diffblue Limited. All Rights Reserved.
// Unpublished proprietary source code.
// Use is governed by https://docs.diffblue.com/licenses/eula
import com.diffblue.cover.tir2jdt.internal.translation.TirToJavaVisitor;

/**
 * This file provides a helper method that will be inserted in the test class whenever the test
 * requires setting fields reflectively.
 *
 * @see TirToJavaVisitor#addHelperMethods(String)
 */
public class ReflectionHelperSetField {

  private static void setField(
      Class<?> declaringClass, Object instance, String fieldName, Object value) {
    try {
      java.lang.reflect.Field field = declaringClass.getDeclaredField(fieldName);
      field.setAccessible(true);
      field.set(instance, value);
    } catch (IllegalAccessException | NoSuchFieldException e) {
      throw new RuntimeException("Unable to reflectively set field '" + fieldName + "'", e);
    }
  }
}
