<!--
Copyright 2023-2025 Diffblue Limited. All Rights Reserved.
Unpublished proprietary source code.
Use is governed by https://docs.diffblue.com/licenses/eula
-->
# Jacoco Execution Detector Resources

This directory houses resources that the Jacoco Dummy tests required to be able to run
successfully.

In order to run a Jacoco Dummy Test, we need to temporarily insert 3 classes into the
users environment. These classes are:

- DiffblueDummyCoverageClass
  - This is the class that we are trying to calculate coverage for
- DiffblueDummyCoverage...Test
  - This is the dummy manual test for calculating manual coverage
- DiffblueDummyCoverage...DiffblueTest
  - This is the dummy Diffblue test for calculating Diffblue coverage

There are 2 versions of each *Test file - one for running on Junit 4, and one for running
on Junit Jupiter 5.

The tests are particular - the Diffblue test covers a different branch of the MUT to the
manual test. This means that we can detect if the generated coverage is equal, 100%, or
0%. In any of these cases, this means something has gone wrong in the Jacoco execution.

### Expected .xml files

Inside the `JacocoDummyCoverageVerifier`, you'll find the methods
`getExpectedDiffblueXml()` and `getExpectedManualXml()`. These methods return a string of
the xml coverage that we expect our Jacoco dummy tests to have on the DummyTestClass.
If the xml files generated contain the correct dummy test class with these coverage
values, then Jacoco execution has gone to plan.

If you need to change or update these files for any reason, then you will need to follow
the following steps:

1. In a *working* simple test project, containing the DiffblueDummyCoverageClass and
   respective *DiffblueTest, generate coverage.
2. Take the resulting jacoco.xml file and find the block contained by
   `<class name="DiffblueDummyCoverageClass" ...>...</class>`
3. Copy this and paste inside a string that is returned by `getExpectedDiffblueXml()`
   (replacing the existing xml coverage)
4. (Optional) Format the string by splitting it after each `>` character
   - If you do this, **do not add or remove anything** from the xml string. The dummy test
     works by comparing the strings of the generated xml with the expected xml, so if there are
     any differences, the comparison will fail.
5. Repeat, but for the manual coverage.

