/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.gradle.plugin;

import com.diffblue.cover.buildsystem.gradle.plugin.Safely;
import com.diffblue.cover.buildsystem.model.Plugin;
import com.diffblue.cover.buildsystem.model.ProjectModule;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;

public class QueryProjectModule
implements ProjectModule {
    private final Project project;
    private final Safely safely;
    private static final String MAIN_SOURCE_SET_NAME = "main";
    private static final String TEST_SOURCE_SET_NAME = "test";

    public QueryProjectModule(Project project) {
        this.project = project;
        this.safely = new Safely(project.getLogger());
    }

    @Nullable
    public List<ProjectModule> getSubModules() {
        return null;
    }

    @Override
    @Nullable
    public String getFullModuleName() {
        return null;
    }

    @Override
    @Nullable
    public String getSimpleModuleName() {
        return null;
    }

    @Override
    @Nullable
    public String getParentModuleName() {
        return null;
    }

    @Override
    @Nullable
    public File getLocation() {
        return null;
    }

    @Override
    @Nullable
    public List<String> getJunitReport() {
        return null;
    }

    @Override
    @Nullable
    public List<String> getJacocoReport() {
        return null;
    }

    @Override
    @Nullable
    public List<String> getJacocoFormats() {
        return null;
    }

    @Override
    @Nullable
    public List<String> getJacocoDestFile() {
        return this.safely.getFirst(this::getJacocoDestFileFromJacocoTask).orElse(null);
    }

    @Nullable
    public List<String> getJacocoDestFileFromJacocoTask() {
        return this.project.getTasks().withType(Test.class).stream().map(t -> (JacocoTaskExtension)t.getExtensions().getByType(JacocoTaskExtension.class)).map(JacocoTaskExtension::getDestinationFile).distinct().map(File::getAbsolutePath).collect(Collectors.toList());
    }

    @Override
    public boolean isJacocoSkipped() {
        return false;
    }

    @Override
    @Nullable
    public List<File> getClasspath() {
        return this.safely.getFirst(this::getClasspathFromTestSourceSetRuntime).orElse(null);
    }

    @Nullable
    public List<File> getClasspathFromTestSourceSetRuntime() {
        SourceSetContainer sourceSetContainer = this.getSourceSetContainer();
        if (sourceSetContainer == null) {
            return null;
        }
        LinkedHashSet classpath = new LinkedHashSet();
        classpath.addAll(((SourceSet)sourceSetContainer.getByName(TEST_SOURCE_SET_NAME)).getRuntimeClasspath().getFiles());
        classpath.addAll(((SourceSet)sourceSetContainer.getByName(TEST_SOURCE_SET_NAME)).getCompileClasspath().getFiles());
        return Arrays.asList(classpath.toArray(new File[0]));
    }

    @Override
    @Nullable
    public String getComplianceLevel() {
        return this.safely.getFirst(this::getComplianceLevelFromJavaCompile).orElse(null);
    }

    @Nullable
    String getComplianceLevelFromJavaCompile() {
        return this.project.getTasks().withType(JavaCompile.class).stream().map(AbstractCompile::getTargetCompatibility).distinct().map(JavaVersion::toVersion).min(Comparator.comparingInt(Enum::ordinal)).map(JavaVersion::toString).orElse(null);
    }

    @Override
    public List<File> getProductionSources() {
        return this.getSources(MAIN_SOURCE_SET_NAME);
    }

    @Override
    public List<File> getTestSources() {
        return this.getSources(TEST_SOURCE_SET_NAME);
    }

    private List<File> getSources(String sourceSetName) {
        return this.safely.getFirst(() -> this.getSourcesFromSourceSetJavaSrcDirs(sourceSetName)).orElse(null);
    }

    @Nullable
    List<File> getSourcesFromSourceSetJavaSrcDirs(String sourceSetName) {
        SourceSetContainer sourceSetContainer = this.getSourceSetContainer();
        if (sourceSetContainer == null) {
            return null;
        }
        return new ArrayList<File>(((SourceSet)sourceSetContainer.getByName(sourceSetName)).getJava().getSrcDirs());
    }

    @Override
    public File getProductionClasses() {
        return this.getClasses(MAIN_SOURCE_SET_NAME);
    }

    @Override
    public File getTestClasses() {
        return this.getClasses(TEST_SOURCE_SET_NAME);
    }

    private File getClasses(String sourceSetName) {
        return this.safely.getFirst(() -> this.getClassesFromJavaClassesDirectory(sourceSetName), () -> this.getClassesFromJavaOutputDir(sourceSetName), () -> this.getClassesFromDestinationDirectory(sourceSetName)).orElse(null);
    }

    @Override
    public File getBuildDirectory() {
        return null;
    }

    @Nullable
    File getClassesFromJavaClassesDirectory(String sourceSetName) {
        SourceSetContainer sourceSetContainer = this.getSourceSetContainer();
        if (sourceSetContainer == null) {
            return null;
        }
        Directory directory = (Directory)((SourceSet)sourceSetContainer.getByName(sourceSetName)).getJava().getClassesDirectory().getOrNull();
        if (directory == null) {
            return null;
        }
        return directory.getAsFile();
    }

    @Nullable
    File getClassesFromJavaOutputDir(String sourceSetName) {
        SourceSetContainer sourceSetContainer = this.getSourceSetContainer();
        if (sourceSetContainer == null) {
            return null;
        }
        return ((SourceSet)sourceSetContainer.getByName(sourceSetName)).getJava().getOutputDir();
    }

    @Nullable
    File getClassesFromDestinationDirectory(String sourceSetName) {
        SourceSetContainer sourceSetContainer = this.getSourceSetContainer();
        if (sourceSetContainer == null) {
            return null;
        }
        return (File)((SourceSet)sourceSetContainer.getByName(sourceSetName)).getJava().getDestinationDirectory().getAsFile().getOrNull();
    }

    @Override
    @Nullable
    public List<Plugin> getPlugins() {
        return null;
    }

    @Override
    @Nullable
    public String getVersion() {
        return null;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    @Nullable
    public String getEncoding() {
        return null;
    }

    @Nullable
    SourceSetContainer getSourceSetContainer() {
        return this.safely.getFirst(this::getSourceSetContainerFromExtension, this::getSourceSetContainerFromProperty).orElse(null);
    }

    SourceSetContainer getSourceSetContainerFromExtension() {
        return (SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class);
    }

    @Nullable
    SourceSetContainer getSourceSetContainerFromProperty() {
        return (SourceSetContainer)this.project.findProperty("sourceSets");
    }

    @Override
    public Map<File, File> getTestSourceToBuildPathMap() {
        return this.getBuildPathsByName(TEST_SOURCE_SET_NAME);
    }

    @Override
    public Map<File, File> getSourceToBuildPathMap() {
        return this.getBuildPathsByName(MAIN_SOURCE_SET_NAME);
    }

    private Map<File, File> getBuildPathsByName(String name) {
        LinkedHashMap<File, File> buildPaths = new LinkedHashMap<File, File>();
        File classes = this.getClasses(name);
        if (classes != null) {
            for (File source : this.getSources(name)) {
                QueryProjectModule.addIfSourceDirExists(buildPaths, source, classes);
            }
        }
        for (String lang : Arrays.asList("java", "kotlin")) {
            QueryProjectModule.addIfSourceDirExists(buildPaths, this.project.getProjectDir().toPath().resolve(Paths.get("src", name, lang)).toFile(), this.project.getBuildDir().toPath().resolve(Paths.get("classes", lang, name)).toFile());
        }
        return buildPaths;
    }

    private static void addIfSourceDirExists(Map<File, File> buildPaths, File sourceDirectory, File buildDirectory) {
        if (Files.isDirectory(sourceDirectory.toPath(), new LinkOption[0])) {
            buildPaths.put(sourceDirectory, buildDirectory);
        }
    }
}

