/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.gradle.plugin;

import com.diffblue.cover.buildsystem.gradle.plugin.QueryProjectModule;
import com.diffblue.cover.buildsystem.model.DefaultPlugin;
import com.diffblue.cover.buildsystem.model.DefaultProjectModuleBuilder;
import com.diffblue.cover.buildsystem.model.Plugin;
import com.diffblue.cover.buildsystem.model.ProjectModule;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.internal.plugins.DefaultPluginManager;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.gradle.plugin.use.PluginId;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoPluginExtension;
import org.gradle.testing.jacoco.tasks.JacocoReport;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class ProjectModuleModelBuilder
implements ToolingModelBuilder {
    public static final String MODEL_NAME = ProjectModule.class.getName();
    private static final String IMPLEMENTATION_NAME_ATTRIBUTE_KEY = "Implementation-Version";

    public boolean canBuild(String modelName) {
        return MODEL_NAME.equals(modelName);
    }

    public Object buildAll(String modelName, Project requestedProject) {
        LinkedList<Object> projects = new LinkedList<Object>();
        projects.add(requestedProject.getRootProject());
        LinkedHashMap<File, DefaultProjectModuleBuilder> modules = new LinkedHashMap<File, DefaultProjectModuleBuilder>();
        LinkedHashMap<File, List> moduleTree = new LinkedHashMap<File, List>();
        while (!projects.isEmpty()) {
            Project project = (Project)projects.poll();
            projects.addAll(project.getChildProjects().values());
            DefaultProjectModuleBuilder moduleBuilder = this.buildModule(project);
            String parentName = this.getParentBasedModuleName(project.getParent());
            moduleBuilder.setParent(parentName);
            String parentModulePath = parentName.isEmpty() ? "" : parentName + ":";
            moduleBuilder.setFullName(parentModulePath + project.getName());
            moduleBuilder.setSimpleName(project.getName());
            File location = project.getProjectDir();
            moduleBuilder.setLocation(location);
            File parentLocation = project.getParent() == null ? null : project.getParent().getProjectDir();
            moduleTree.computeIfAbsent(parentLocation, k -> new LinkedList()).add(location);
            modules.put(location, moduleBuilder);
        }
        for (Map.Entry module : modules.entrySet()) {
            ((DefaultProjectModuleBuilder)module.getValue()).setBuildSystemVersion(requestedProject.getGradle().getGradleVersion());
        }
        return ProjectModuleModelBuilder.treeify(moduleTree, modules).build();
    }

    private String getParentBasedModuleName(Project project) {
        if (project == null || project == project.getRootProject()) {
            return "";
        }
        String parentModulePath = this.getParentBasedModuleName(project.getParent());
        parentModulePath = parentModulePath.isEmpty() ? "" : parentModulePath + ":";
        return parentModulePath + project.getName();
    }

    private static <T> DefaultProjectModuleBuilder treeify(Map<T, List<T>> moduleTree, Map<T, DefaultProjectModuleBuilder> modules) {
        moduleTree.forEach((parent, children) -> {
            List<DefaultProjectModuleBuilder> childModules = children.stream().filter(modules::containsKey).map(modules::get).collect(Collectors.toList());
            DefaultProjectModuleBuilder parentModelBuilder = modules.getOrDefault(parent, null);
            if (parentModelBuilder != null) {
                parentModelBuilder.setSubModules(childModules);
            } else {
                childModules.forEach(child -> child.setParent(null));
            }
        });
        Set roots = modules.values().stream().filter(b -> b.getParent() == null).collect(Collectors.toCollection(LinkedHashSet::new));
        assert (roots.size() == 1) : "expect only a single root module when constructing a model of the gradle project";
        return (DefaultProjectModuleBuilder)roots.stream().findFirst().get();
    }

    private DefaultProjectModuleBuilder buildModule(Project project) {
        List<String> junitReportDir = this.getJunitReportDir(project);
        List<String> jacocoReportDir = this.getJacocoTestReport(project);
        List<Plugin> plugins = this.getPlugins(project);
        String version = project.getGradle().getGradleVersion();
        String encoding = this.getTestEncoding(project);
        QueryProjectModule query = new QueryProjectModule(project);
        return new DefaultProjectModuleBuilder().setJunitReportDirectories(junitReportDir).setJacocoReportDirectories(jacocoReportDir).setRuntimeClasspath(query.getClasspath()).setJavaComplianceLevel(query.getComplianceLevel()).setProductionSourceDirectories(query.getProductionSources()).setTestSourceDirectories(query.getTestSources()).setProductionClasses(query.getProductionClasses()).setTestClasses(query.getTestClasses()).setProductionSourceToBuildPathMap(query.getSourceToBuildPathMap()).setTestSourceToBuildPathMap(query.getTestSourceToBuildPathMap()).setActivePlugins(plugins).setBuildSystemVersion(version).setEncoding(encoding).setBuildSystemName("gradle").setFullName(project.getName()).setJacocoDestFile(query.getJacocoDestFile());
    }

    @Nullable
    private List<Plugin> getPlugins(Project project) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        DefaultPluginManager manager = (DefaultPluginManager)project.getPluginManager();
        for (org.gradle.api.Plugin plugin : manager.getPluginContainer()) {
            String version;
            String name = plugin.getClass().getName();
            try {
                Optional<String> optionalVersion = plugin instanceof JacocoPlugin ? ProjectModuleModelBuilder.getJacocoVersion(project) : ProjectModuleModelBuilder.getVersionFromJar(plugin);
                version = optionalVersion.orElse(null);
            }
            catch (NullPointerException e) {
                version = null;
            }
            plugins.add(new DefaultPlugin(null, null, version, name));
        }
        return plugins;
    }

    @Nullable
    private List<Plugin> getPluginsUnstable(Project project) {
        PluginManager manager = project.getPluginManager();
        if (!(manager instanceof DefaultPluginManager)) {
            return null;
        }
        if (!this.isDefaultPluginManagerFindPluginIdForClassAvailable()) {
            return null;
        }
        return this.safe(() -> project.getPlugins().stream().map(plugin -> {
            Optional pluginIdForClass = ((DefaultPluginManager)manager).findPluginIdForClass(plugin.getClass());
            if (!pluginIdForClass.isPresent()) {
                return null;
            }
            PluginId pluginId = (PluginId)pluginIdForClass.get();
            String groupId = pluginId.getNamespace();
            String artifactId = pluginId.getName();
            Optional<String> versionFromJar = ProjectModuleModelBuilder.getVersionFromJar(plugin);
            String version = versionFromJar != null ? versionFromJar.orElse(project.getGradle().getGradleVersion()) : null;
            return new DefaultPlugin(groupId, artifactId, version, null);
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private static Optional<String> getJacocoVersion(Project project) {
        return Optional.ofNullable((JacocoPluginExtension)project.getExtensions().findByType(JacocoPluginExtension.class)).map(JacocoPluginExtension::getToolVersion);
    }

    @Nullable
    private static Optional<String> getVersionFromJar(org.gradle.api.Plugin<?> plugin) {
        Optional<String> optional;
        URI pluginJarLocation;
        try {
            pluginJarLocation = plugin.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException ignored) {
            return null;
        }
        JarFile jarFile = new JarFile(Paths.get(pluginJarLocation).toFile());
        try {
            optional = Optional.ofNullable(jarFile.getManifest().getMainAttributes().getValue(IMPLEMENTATION_NAME_ATTRIBUTE_KEY));
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored) {
                return Optional.empty();
            }
        }
        jarFile.close();
        return optional;
    }

    @Nullable
    private List<String> getJunitReportDir(Project project) {
        return this.safe(() -> project.getTasks().withType(Test.class).stream().map(AbstractTestTask::getReports).map(TestTaskReports::getJunitXml).map(this::getOutput).filter(Objects::nonNull).map(File::getAbsolutePath).collect(Collectors.toList()));
    }

    @Nullable
    private List<String> getJacocoTestReport(Project project) {
        return this.safe(() -> this.filesToPaths(project.getTasks().withType(JacocoReport.class).stream().map(task -> task.getReports().getXml()).map(this::getOutput).collect(Collectors.toList())));
    }

    @Nullable
    private String getTestEncoding(Project project) {
        return this.safe(() -> ((JavaCompile)project.getTasks().withType(JavaCompile.class).getByName("compileTestJava")).getOptions().getEncoding());
    }

    @Nullable
    private List<String> filesToPaths(@Nullable Collection<File> files) {
        if (files == null) {
            return null;
        }
        return files.stream().map(File::getAbsolutePath).collect(Collectors.toList());
    }

    @Nullable
    private <R> R safe(Supplier<R> fn) {
        try {
            return fn.get();
        }
        catch (UnknownDomainObjectException ignored) {
            return null;
        }
    }

    private File getOutput(Report report) {
        if (report instanceof DirectoryReport && ProjectModuleModelBuilder.isMethodPresent(DirectoryReport.class, "getOutputLocation")) {
            return (File)((DirectoryReport)report).getOutputLocation().getAsFile().getOrNull();
        }
        if (report instanceof SingleFileReport && ProjectModuleModelBuilder.isMethodPresent(SingleFileReport.class, "getOutputLocation")) {
            return (File)((SingleFileReport)report).getOutputLocation().getAsFile().getOrNull();
        }
        if (ProjectModuleModelBuilder.isMethodPresent(Report.class, "getDestination")) {
            return report.getDestination().getAbsoluteFile();
        }
        return null;
    }

    private boolean isDefaultPluginManagerFindPluginIdForClassAvailable() {
        return ProjectModuleModelBuilder.isMethodPresent(DefaultPluginManager.class, "findPluginIdForClass");
    }

    static boolean isMethodPresent(Class<?> clazz, String method) {
        return Arrays.stream(clazz.getMethods()).map(Method::getName).anyMatch(method::equals);
    }
}

