/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.gradle.plugin;

import com.diffblue.cover.buildsystem.gradle.plugin.Safely;
import groovy.json.JsonOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestFramework;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestFramework;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestFramework;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.impldep.org.apache.commons.io.FileUtils;
import org.gradle.internal.impldep.org.jetbrains.annotations.VisibleForTesting;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.gradle.testing.jacoco.tasks.JacocoReport;

class JacocoManager {
    private final Project project;
    private static final Logger logger = Logging.getLogger(JacocoManager.class);
    private final Safely safely;

    static void configure(Project project) {
        JacocoManager manager = new JacocoManager(project);
        project.afterEvaluate(ignored -> manager.configure());
    }

    JacocoManager(Project project) {
        this.project = project;
        this.safely = new Safely(logger);
    }

    void configure() {
        if (this.configurePlugins()) {
            this.configureTasks();
        }
    }

    boolean configurePlugins() {
        if (!this.project.getPlugins().hasPlugin(JavaPlugin.class)) {
            return false;
        }
        logger.info("Configuring Jacoco Plugin for use with Diffblue Cover");
        this.project.getPlugins().apply(JacocoPlugin.class);
        return true;
    }

    void configureTasks() {
        Optional<Path> defaultExecFile = this.getDefaultExecFile();
        Test test = this.configureTestTask();
        JacocoReport jacocoReportTask = this.configureJacocoReportTask(test, defaultExecFile);
        Task deletePrevious = this.configureJacocoReportDeletePrevious(jacocoReportTask);
        Task prepareEmptyExec = this.configureJacocoReportPrepareEmptyExecTask(test, jacocoReportTask);
        Task moveTestXMLBack = this.configureMoveTestXMLBackTask(test);
        Task moveBackExecFile = this.configureMoveBackTestExecTask(test, defaultExecFile);
        Task deletePreviousExecFile = this.configureDeletePreviousExecFiles(test);
        this.configureTasksDisableCaching(new Task[]{jacocoReportTask, deletePrevious, prepareEmptyExec, moveTestXMLBack, moveBackExecFile, deletePreviousExecFile});
    }

    private Optional<Path> getDefaultExecFile() {
        return Optional.ofNullable(((JacocoTaskExtension)((Test)this.project.getTasks().withType(Test.class).getByName("test")).getExtensions().getByType(JacocoTaskExtension.class)).getDestinationFile()).map(File::getAbsoluteFile).map(File::toPath);
    }

    private void configureTasksDisableCaching(Task ... tasks) {
        for (Task task : tasks) {
            this.safely.runFirst(() -> task.doNotTrackState("Cover needs fresh coverage information"), () -> task.getOutputs().upToDateWhen(t -> false));
        }
    }

    @VisibleForTesting
    boolean isMergeCoverageEnabled() {
        return Optional.ofNullable(this.project.findProperty("mergeCoverage")).map("true"::equals).orElse(false);
    }

    private Test configureTestTask() {
        TestFramework testFramework;
        Test test = (Test)this.project.getTasks().withType(Test.class).getByName("test");
        logger.info("Configuring task {} for use with Diffblue Cover", (Object)test.getPath());
        Optional.ofNullable(this.project.findProperty("ignoreFailures")).map("true"::equals).ifPresent(arg_0 -> ((Test)test).setIgnoreFailures(arg_0));
        Optional.ofNullable(this.project.findProperty("excludeTests")).map(Object::toString).ifPresent(xva$0 -> test.exclude(new String[]{xva$0}));
        Optional.ofNullable(this.project.findProperty("includeTests")).map(Object::toString).ifPresent(xva$0 -> test.include(new String[]{xva$0}));
        Optional<String> includeGroup = Optional.ofNullable(this.project.findProperty("includeGroup")).map(Object::toString);
        Optional<String> excludeGroup = Optional.ofNullable(this.project.findProperty("excludeGroup")).map(Object::toString);
        logger.info("ignoreFailures: {}", (Object)test.getIgnoreFailures());
        logger.info("excludes: {}", (Object)test.getExcludes());
        logger.info("includes: {}", (Object)test.getIncludes());
        if (includeGroup.isPresent()) {
            logger.info("includeGroup: {}", (Object)includeGroup.get());
        }
        if (excludeGroup.isPresent()) {
            logger.info("excludeGroup: {}", (Object)excludeGroup.get());
        }
        if (!includeGroup.isPresent() && !excludeGroup.isPresent()) {
            logger.info("No group filtering configured");
        }
        if (test == null) {
            return test;
        }
        Optional<Path> execFilePath = this.getExecFilePath(test);
        if (execFilePath.isPresent()) {
            Path execFile = this.isMergeCoverageEnabled() ? JacocoManager.getTagExecPath(execFilePath.get()) : execFilePath.get();
            logger.info("Saving execution data to: {}", (Object)execFile);
            ((JacocoTaskExtension)test.getExtensions().getByType(JacocoTaskExtension.class)).setDestinationFile(execFile.toFile());
        }
        if ((testFramework = test.getTestFramework()) == null) {
            logger.warn("TestFramework is not set");
            return test;
        }
        logger.info("testFramework: {}", testFramework.getClass());
        if (testFramework instanceof JUnitPlatformTestFramework) {
            JacocoManager.setJunit5Tag((JUnitPlatformTestFramework)testFramework, includeGroup, excludeGroup);
        } else if (testFramework instanceof JUnitTestFramework) {
            JacocoManager.setJunit4Categories((JUnitTestFramework)testFramework, includeGroup, excludeGroup);
        } else if (testFramework instanceof TestNGTestFramework) {
            JacocoManager.setTestNGGroups((TestNGTestFramework)testFramework, includeGroup, excludeGroup);
        } else {
            logger.warn("TestFramework is not supported");
        }
        logger.info("Getting testXMLPath");
        Path testXmlPath = ((Directory)test.getReports().getJunitXml().getOutputLocation().get()).getAsFile().toPath();
        logger.info("testXMLPath exists: {}", (Object)testXmlPath.toFile().exists());
        Path diffblueTempPath = testXmlPath.getParent().resolve("diffblueTemp");
        logger.info("diffblueTempPath: {}", (Object)diffblueTempPath.toFile());
        if (!diffblueTempPath.toFile().exists()) {
            logger.info("Creating diffblueTempPath");
            diffblueTempPath.toFile().mkdir();
        }
        if (!this.isMergeCoverageEnabled() && diffblueTempPath.toFile().exists()) {
            this.safely.runFirst(() -> {
                try {
                    Files.walkFileTree(diffblueTempPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    logger.info("Failed delete files: {}", (Throwable)e);
                }
            }, () -> logger.info("No files to move"));
        }
        logger.info("diffblueTempPath exists after mkdir: {}", (Object)diffblueTempPath.toFile().exists());
        return test;
    }

    private static Path getTagExecPath(Path execFilePath) {
        return Paths.get(execFilePath.getParent().toString(), "tag_test.exec");
    }

    @VisibleForTesting
    static Path getTempExecPath(Path execFilePath) {
        return Paths.get(execFilePath.getParent().toString(), "diffblue_temp.exec");
    }

    @VisibleForTesting
    static void setJunit5Tag(JUnitPlatformTestFramework testFramework, Optional<String> includeGroup, Optional<String> excludeGroup) {
        testFramework.getOptions().setIncludeTags(JacocoManager.splitGroup(includeGroup));
        testFramework.getOptions().setExcludeTags(JacocoManager.splitGroup(excludeGroup));
    }

    @VisibleForTesting
    static void setJunit4Categories(JUnitTestFramework testFramework, Optional<String> includeGroup, Optional<String> excludeGroup) {
        testFramework.getOptions().setIncludeCategories((Set)JacocoManager.splitGroup(includeGroup).stream().map(JacocoManager::convertJunit4Category).collect(Collectors.toCollection(LinkedHashSet::new)));
        testFramework.getOptions().setExcludeCategories((Set)JacocoManager.splitGroup(excludeGroup).stream().map(JacocoManager::convertJunit4Category).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    @VisibleForTesting
    static void setTestNGGroups(TestNGTestFramework testFramework, Optional<String> includeGroup, Optional<String> excludeGroup) {
        testFramework.getOptions().setIncludeGroups(JacocoManager.splitGroup(includeGroup));
        testFramework.getOptions().setExcludeGroups(JacocoManager.splitGroup(excludeGroup));
    }

    private static String convertJunit4Category(String category) {
        if (category != null && (category.equals("MaintainedByDiffblue") || category.equals("ContributionFromDiffblue"))) {
            return "com.diffblue.cover.annotations." + category;
        }
        return category;
    }

    private static Set<String> splitGroup(Optional<String> group) {
        return group.map(s -> Arrays.stream(s.split(",")).collect(Collectors.toCollection(LinkedHashSet::new))).orElse(new LinkedHashSet());
    }

    private JacocoReport configureJacocoReportTask(Test test, Optional<Path> defaultExecFile) {
        JacocoReport jacocoReport = (JacocoReport)this.project.getTasks().withType(JacocoReport.class).getByName("jacocoTestReport");
        logger.info("Configuring task {} for use with Diffblue Cover", (Object)jacocoReport.getPath());
        test.finalizedBy(new Object[]{jacocoReport});
        Optional<Path> execFilePath = this.getExecFilePath(test);
        if (execFilePath.isPresent() && this.isMergeCoverageEnabled()) {
            Path tagExecPath = JacocoManager.getTagExecPath(execFilePath.get());
            if (defaultExecFile.isPresent()) {
                logger.info("Adding exec files to make report: {}, {}", (Object)defaultExecFile.get(), (Object)tagExecPath);
                jacocoReport.executionData(new Object[]{defaultExecFile.get(), tagExecPath});
            } else {
                logger.info("Adding exec files to make report: {}", (Object)tagExecPath);
                jacocoReport.executionData(new Object[]{tagExecPath});
            }
        }
        logger.info("executionData: {}", (Object)jacocoReport.getExecutionData());
        jacocoReport.setOnlyIf(spec -> true);
        this.setJacocoReportXmlRequired(jacocoReport);
        jacocoReport.doLast(task -> {
            String json = JsonOutput.toJson(Collections.singletonMap("jacocoXmlReport", this.getJacocoReportOutputLocation(jacocoReport).map(File::getAbsoluteFile).map(File::toString).orElse(null)));
            logger.info("(diffblue-json){}(/diffblue-json)", (Object)json);
        });
        return jacocoReport;
    }

    private Optional<Path> getExecFilePath(Test test) {
        return Optional.ofNullable(((JacocoTaskExtension)test.getExtensions().getByType(JacocoTaskExtension.class)).getDestinationFile()).map(File::getAbsoluteFile).map(File::toPath);
    }

    private Task configureJacocoReportDeletePrevious(JacocoReport jacocoReport) {
        return (Task)this.project.getTasks().create(jacocoReport.getName() + "DeletePrevious", task -> {
            logger.info("Configuring task {} for use with Diffblue Cover", (Object)task.getPath());
            jacocoReport.dependsOn(new Object[]{task});
            this.getJacocoReportOutputLocation(jacocoReport).ifPresent(file -> {
                logger.info("Adding {} to be deleted", file);
                task.getDestroyables().register(new Object[]{file});
            });
        });
    }

    private Task configureMoveTestXMLTask(Test test) {
        return (Task)this.project.getTasks().create(test.getName() + "MoveTestXML", task -> {
            logger.info("Configuring task {} for use with Diffblue Cover", (Object)task.getPath());
            test.dependsOn(new Object[]{task});
            logger.info("Getting testXMLPath");
            Path testXmlPath = ((Directory)test.getReports().getJunitXml().getOutputLocation().get()).getAsFile().toPath();
            logger.info("testXMLPath exists: {}", (Object)testXmlPath.toFile().exists());
            Path diffblueTempPath = testXmlPath.getParent().resolve("diffblueTemp");
            logger.info("diffblueTempPath: {}", (Object)diffblueTempPath.toFile());
            if (!this.isMergeCoverageEnabled()) {
                if (diffblueTempPath.toFile().exists()) {
                    logger.info("diffblueTempPath files: {}", (Object[])diffblueTempPath.toFile().listFiles());
                    logger.info("Adding {} to be deleted - no merging and diffbluePath exists", (Object)diffblueTempPath);
                    task.getDestroyables().register(new Object[]{diffblueTempPath});
                }
            } else {
                logger.info("Not adding {} to be deleted - merging", (Object)diffblueTempPath);
            }
        });
    }

    private Task configureMoveTestXMLBackTask(Test test) {
        return (Task)this.project.getTasks().create(test.getName() + "MoveTestXMLBack", task -> {
            logger.info("Configuring task {} for use with Diffblue Cover", (Object)task.getPath());
            test.finalizedBy(new Object[]{task});
            if (!((Directory)test.getReports().getJunitXml().getOutputLocation().get()).getAsFile().exists()) {
                return;
            }
            final Path testXmlPath = ((Directory)test.getReports().getJunitXml().getOutputLocation().get()).getAsFile().toPath();
            logger.info("testXMLPath exists: {}", (Object)testXmlPath.toFile().exists());
            final Path diffblueTempPath = testXmlPath.getParent().resolve("diffblueTemp");
            logger.info("diffblueTempPath before: {}", (Object[])diffblueTempPath.toFile().listFiles());
            logger.info("textXmlPAth files before: {}", (Object[])testXmlPath.toFile().listFiles());
            task.doLast((Action)new Action<Task>(){

                public void execute(Task ignored) {
                    if (diffblueTempPath.toFile().exists()) {
                        JacocoManager.this.safely.runFirst(() -> {
                            try {
                                if (JacocoManager.this.isMergeCoverageEnabled()) {
                                    Files.walkFileTree(diffblueTempPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                        @Override
                                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                            Path target = testXmlPath.resolve(file.getFileName());
                                            if (!Files.exists(target, new LinkOption[0]) && target.getFileName().toString().toUpperCase().endsWith(".XML")) {
                                                logger.info("Moving {} to {}", (Object)file, (Object)target);
                                                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                                                Files.copy(file, target, StandardCopyOption.REPLACE_EXISTING);
                                            }
                                            return FileVisitResult.CONTINUE;
                                        }
                                    });
                                } else {
                                    Files.walkFileTree(testXmlPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                        @Override
                                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                            Path target = diffblueTempPath.resolve(file.getFileName());
                                            if (!Files.exists(target, new LinkOption[0]) && target.getFileName().toString().toUpperCase().endsWith(".XML")) {
                                                logger.info("Moving {} to {}", (Object)file, (Object)target);
                                                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                                                Files.copy(file, target, StandardCopyOption.REPLACE_EXISTING);
                                            }
                                            return FileVisitResult.CONTINUE;
                                        }
                                    });
                                }
                            }
                            catch (IOException e) {
                                logger.info("Failed to move files: {}", (Throwable)e);
                            }
                        }, () -> logger.info("No files to move"));
                    }
                }
            });
        });
    }

    @VisibleForTesting
    Task configureDeletePreviousExecFiles(Test test) {
        return (Task)this.project.getTasks().create(test.getName() + "DeletePreviousExecFiles", task -> {
            logger.info("Configuring task {} for use with Diffblue Cover", (Object)task.getPath());
            test.dependsOn(new Object[]{task});
            Optional<Path> execFile = this.getExecFilePath(test);
            task.doFirst(t -> {
                if (execFile.isPresent() && Files.exists((Path)execFile.get(), new LinkOption[0])) {
                    logger.info("Adding {} to be deleted", execFile.get());
                    try {
                        Files.delete((Path)execFile.get());
                    }
                    catch (IOException e) {
                        logger.info("Failed to delete previous exec file", (Throwable)e);
                    }
                }
            });
        });
    }

    @VisibleForTesting
    Task configureMoveBackTestExecTask(Test test, Optional<Path> defaultExecFile) {
        return (Task)this.project.getTasks().create(test.getName() + "MoveBackJacocoExec", task -> {
            logger.info("Configuring task {} for use with Diffblue Cover", (Object)task.getPath());
            test.finalizedBy(new Object[]{task});
            if (this.isMergeCoverageEnabled()) {
                defaultExecFile.ifPresent(file -> {
                    try {
                        Path tempFile = JacocoManager.getTempExecPath(file);
                        if (Files.exists(file, new LinkOption[0])) {
                            logger.info("Copying exec file {} to {}", file, (Object)tempFile);
                            Files.copy(file, tempFile, StandardCopyOption.REPLACE_EXISTING);
                        } else {
                            logger.info("Not copying exec file as it doesn't exist: {}", file);
                        }
                    }
                    catch (IOException e) {
                        logger.info("Failed to copy exec file", (Throwable)e);
                    }
                });
            }
            task.doLast(ignored -> defaultExecFile.ifPresent(file -> {
                try {
                    Path tempFile = JacocoManager.getTempExecPath(file);
                    if (Files.exists(tempFile, new LinkOption[0]) && !Files.exists((Path)defaultExecFile.get(), new LinkOption[0])) {
                        logger.info("Moving temp exec file {} back to {}", (Object)tempFile, defaultExecFile.get());
                        Files.copy(tempFile, (Path)defaultExecFile.get(), new CopyOption[0]);
                        Files.delete(tempFile);
                    }
                }
                catch (IOException e) {
                    logger.info("Failed to move exec file back,", (Throwable)e);
                }
            }));
        });
    }

    private static void copyContents(File source, File dest) throws IOException {
        if (source.isDirectory()) {
            FileUtils.copyDirectory((File)source, (File)dest);
        } else {
            FileUtils.copyFile((File)source, (File)dest);
        }
    }

    private Task configureJacocoReportPrepareEmptyExecTask(Test test, JacocoReport jacocoReport) {
        return (Task)this.project.getTasks().create(jacocoReport.getName() + "PrepareEmptyExec", task -> {
            logger.info("Configuring task {} for use with Diffblue Cover", (Object)task.getPath());
            task.dependsOn(new Object[]{test});
            jacocoReport.dependsOn(new Object[]{task});
            Optional.ofNullable(((JacocoTaskExtension)test.getExtensions().getByType(JacocoTaskExtension.class)).getDestinationFile()).map(File::getAbsoluteFile).map(File::toPath).ifPresent(path -> {
                task.getOutputs().file(path);
                task.doLast((Action)new Action<Task>(){

                    public void execute(Task ignored) {
                        logger.info("preparing empty exec: {}", (Object)path);
                        if (!Files.exists(path, new LinkOption[0])) {
                            try {
                                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            try {
                                Files.createFile(path, new FileAttribute[0]);
                            }
                            catch (IOException iOException) {}
                        } else {
                            logger.info("not creating empty exec: {}", (Object)path);
                        }
                    }
                });
            });
        });
    }

    private void setJacocoReportXmlRequired(JacocoReport jacocoReport) {
        jacocoReport.reports(reports -> this.safely.runFirst(() -> reports.getXml().getRequired().set((Object)true), () -> reports.getXml().setEnabled(true)));
    }

    private Optional<File> getJacocoReportOutputLocation(JacocoReport jacocoReport) {
        return this.safely.getFirst(() -> ((RegularFile)jacocoReport.getReports().getXml().getOutputLocation().get()).getAsFile(), () -> jacocoReport.getReports().getXml().getDestination()).map(File::getAbsoluteFile);
    }
}

