/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.gradle.plugin;

import com.diffblue.cover.buildsystem.model.DefaultDownloadDependencyMessage;
import com.diffblue.cover.buildsystem.serialization.Utils;
import java.io.File;
import javax.annotation.Nonnull;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class DownloadTask
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(DownloadTask.class);
    private String groupId;
    private String artifactId;
    private String version;

    @Input
    public String getGroupId() {
        return this.groupId;
    }

    @Option(option="groupId", description="The groupId to download")
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Input
    public String getArtifactId() {
        return this.artifactId;
    }

    @Option(option="artifactId", description="The artifactId to download")
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Input
    public String getVersion() {
        return this.version;
    }

    @Option(option="version", description="The version to download")
    public void setVersion(String version) {
        this.version = version;
    }

    @TaskAction
    void downloadDependencies() {
        Project project = this.getProject();
        Configuration configuration = DownloadTask.getOrCreateDownloadConfiguration(project);
        configuration.getResolutionStrategy().deactivateDependencyLocking();
        configuration.setTransitive(false);
        Task downloadTask = DownloadTask.getOrRegisterDownloadTask(project);
        downloadTask.dependsOn(new Object[]{configuration});
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add("__diffblue__Download", (Object)String.format("%s:%s:%s", this.groupId, this.artifactId, this.version));
        File singleFile = configuration.getSingleFile();
        Utils.writeMessage(new DefaultDownloadDependencyMessage(singleFile, this.groupId, this.artifactId, this.version), (arg_0, arg_1) -> ((Logger)logger).info(arg_0, arg_1));
    }

    @Nonnull
    private static Configuration getOrCreateDownloadConfiguration(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        try {
            return configurations.getByName("__diffblue__Download");
        }
        catch (UnknownConfigurationException e) {
            return (Configuration)configurations.register("__diffblue__Download").get();
        }
    }

    @Nonnull
    private static Task getOrRegisterDownloadTask(Project project) {
        try {
            return project.getTasks().getByName("__diffblue__Download");
        }
        catch (UnknownTaskException e) {
            return (Task)project.getTasks().register("__diffblue__Download").get();
        }
    }
}

