/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.fuzztest.shared.proxy.spring;

import com.diffblue.fuzztest.shared.proxy.spring.BeanClassInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BeanDependencies {
    private final Set<BeanClassInfo> uniqueBeans;
    private final Map<String, BeanClassInfo> namedBeans;

    public BeanDependencies(Set<BeanClassInfo> uniqueBeans, Map<String, BeanClassInfo> namedBeans) {
        this.uniqueBeans = uniqueBeans;
        this.namedBeans = namedBeans;
    }

    public boolean isEmpty() {
        return this.uniqueBeans.isEmpty() && this.namedBeans.isEmpty();
    }

    public List<Entry> allBeans() {
        return Stream.concat(this.uniqueBeans.stream().map(beanClassInfo -> new Entry("", (BeanClassInfo)beanClassInfo)), this.namedBeans.entrySet().stream().map(entry -> new Entry((String)entry.getKey(), (BeanClassInfo)entry.getValue()))).collect(Collectors.toList());
    }

    public static class Entry {
        public final String beanName;
        public final BeanClassInfo beanClassInfo;

        public Entry(String beanName, BeanClassInfo beanClassInfo) {
            this.beanName = beanName;
            this.beanClassInfo = beanClassInfo;
        }

        public String toString() {
            return "Entry{beanName='" + this.beanName + '\'' + ", beanClassInfo=" + this.beanClassInfo + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return Objects.equals(this.beanName, entry.beanName) && Objects.equals(this.beanClassInfo, entry.beanClassInfo);
        }

        public int hashCode() {
            return Objects.hash(this.beanName, this.beanClassInfo);
        }
    }
}

