/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.launcher;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public enum Packages implements Predicate<String>
{
    STANDARD_LIBRARY("java", "javax", "org.ietf.jgss", "org.omg.CORBA", "org.omg.CORBA_2_3", "org.omg.CosNaming", "org.omg.Dynamic", "org.omg.DynamicAny", "org.omg.IOP", "org.omg.Messaging", "org.omg.PortableInterceptor", "org.omg.PortableServer", "org.omg.SendingContext", "org.omg.stub.java.rmi", "org.w3c.dom", "org.xml.sax", "com.oracle", "jdk", "org.jcp.xml.dsig", "sun", "com.sun.accessibility.internal.resources", "com.sun.activation.registries", "com.sun.awt", "com.sun.beans", "com.sun.corba.se", "com.sun.demo.jvmti.hprof", "com.sun.imageio", "com.sun.istack.internal", "com.sun.java", "com.sun.java_cup.internal.runtime", "com.sun.jmx", "com.sun.jndi", "com.sun.management", "com.sun.media.sound", "com.sun.naming.internal", "com.sun.net", "com.sun.nio", "com.sun.org", "com.sun.rmi.rmid", "com.sun.rowset", "com.sun.security", "com.sun.swing.internal.plaf", "com.sun.tracing", "com.sun.xml.internal", "org.graalvm"),
    SHARED_JAR("com.diffblue.cover.launcher", "com.diffblue.cover.agent", "com.diffblue.fuzztest.shared"),
    SPRING_ISOLATION_JAR("com.diffblue.spring.isolation"),
    SPRING_FRAMEWORK("org.springframework"),
    COVER("com.diffblue");

    private final Pattern pattern;

    private Packages(String ... packagePrefix) {
        String regex = Arrays.stream(packagePrefix).map(Pattern::quote).collect(Collectors.joining("|", "^(", ")\\."));
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public boolean test(String className) {
        return this.pattern.matcher(className).find();
    }
}

