/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.launcher;

import com.diffblue.cover.launcher.LoadingPolicy;
import java.net.URL;
import java.net.URLClassLoader;

public abstract class FilteringClassLoader
extends URLClassLoader {
    private final StackTraceElement[] stackTrace = new Exception().getStackTrace();

    public FilteringClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public abstract LoadingPolicy findPolicy(String var1);

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClassBasedOnPolicy(name, false);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClassBasedOnPolicy(name, resolve);
    }

    private Class<?> loadClassBasedOnPolicy(String name, boolean resolve) throws ClassNotFoundException {
        switch (this.findPolicy(name)) {
            case DELEGATE_THEN_LOCAL: {
                return super.loadClass(name, resolve);
            }
            case LOCAL_THEN_DELEGATE: {
                try {
                    return this.loadLocal(name, resolve);
                }
                catch (ClassNotFoundException e) {
                    return super.loadClass(name, resolve);
                }
            }
        }
        throw new ClassNotFoundException(name);
    }

    private Class<?> loadLocal(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            clazz = this.findClass(name);
        }
        if (resolve) {
            super.resolveClass(clazz);
        }
        return clazz;
    }
}

