/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.agent.readwrite;

import com.diffblue.cover.agent.common.AgentLogging;
import com.diffblue.cover.agent.readwrite.Access;
import com.diffblue.cover.agent.readwrite.CodeUnderTestClassLoaderMarker;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class Runtime {
    private static final IdentityHashMap<Object, Object> virtualAliases = new IdentityHashMap();
    private static Set<Access> reads;
    private static Set<Access> writes;
    private static List<Integer> observedIntValues;
    private static List<String> observedStringValues;
    private static List<Pattern> observedPatternValues;
    private static List<Float> observedFloatValues;
    private static List<Double> observedDoubleValues;
    private static List<String> instanceOfOrCastClasses;
    private static boolean arrayLengthRead;
    private static boolean nullTestFound;
    private static List<RecordedValues.FailedNullCheck> failedNullChecks;
    private static Set<CharSequence> observedRegexInputValues;
    private static IdentityHashMap<Object, Void> knownNew;
    @Nullable
    private static IdentityHashMap<Object, Void> whitelistToRead;
    @Nullable
    private static IdentityHashMap<Object, Void> whitelistToWrite;
    private static boolean logToStderr;
    private static boolean logObservedValues;
    private static int recordingsInProgress;
    public static final int MAX_VALUES = 50;
    public static volatile ClassToRecord recordValuesForClass;
    static SingleRowBooleanCache<Class<?>> cacheForShouldRecordValueFoundInClass;

    private Runtime() {
    }

    public static void initializeReadWhitelistToEmpty() {
        whitelistToRead = new IdentityHashMap();
    }

    public static void addWhitelistToRead(@Nullable Object whitelist) {
        if (whitelist == null) {
            return;
        }
        if (whitelistToRead == null) {
            whitelistToRead = new IdentityHashMap();
        }
        whitelistToRead.put(whitelist, null);
    }

    public static void initializeWriteWhitelistToEmpty() {
        whitelistToWrite = new IdentityHashMap();
    }

    public static void addToWriteWhitelist(Iterable<Object> objects) {
        if (whitelistToWrite == null) {
            whitelistToWrite = new IdentityHashMap();
        }
        for (Object object : objects) {
            whitelistToWrite.put(object, null);
        }
    }

    public static void setLogObservedValues(boolean value) {
        logObservedValues = value;
    }

    public static void startRecordingWrites() {
        if (recordingsInProgress++ == 0) {
            Runtime.resetRedirects();
            knownNew = new IdentityHashMap();
        }
        writes = new LinkedHashSet<Access>();
        AgentLogging.trace("Starting write recording", new Object[0]);
    }

    public static Set<Access> stopRecordingWrites() {
        Set<Access> oldWrites = writes != null ? Collections.unmodifiableSet(writes) : null;
        writes = null;
        if (--recordingsInProgress <= 0) {
            recordingsInProgress = 0;
            knownNew = null;
        }
        AgentLogging.trace("Stopping write recording, write set pointer is %x", System.identityHashCode(oldWrites));
        return oldWrites;
    }

    public static void startRecordingValues(Class<?> forClass) {
        if (!(forClass.getClassLoader() instanceof CodeUnderTestClassLoaderMarker)) {
            throw new RuntimeException("Value-recording will not work for class " + forClass.getName() + " as the read/write agent has not instrumented it. Classloader = " + forClass.getClassLoader().getClass().getName());
        }
        recordValuesForClass = new ClassToRecord(forClass);
        observedIntValues = new ArrayList<Integer>();
        observedStringValues = new ArrayList<String>();
        observedPatternValues = new ArrayList<Pattern>();
        observedFloatValues = new ArrayList<Float>();
        observedDoubleValues = new ArrayList<Double>();
        instanceOfOrCastClasses = new ArrayList<String>();
        arrayLengthRead = false;
        nullTestFound = false;
        failedNullChecks = new ArrayList<RecordedValues.FailedNullCheck>();
        observedRegexInputValues = new LinkedHashSet<CharSequence>();
    }

    public static RecordedValues stopRecordingValues() {
        recordValuesForClass = null;
        cacheForShouldRecordValueFoundInClass.clear();
        List<String> oldStrings = Collections.unmodifiableList(observedStringValues);
        List<Pattern> oldPatterns = Collections.unmodifiableList(observedPatternValues);
        List<Integer> oldIntegers = Collections.unmodifiableList(observedIntValues);
        List<Float> oldFloats = Collections.unmodifiableList(observedFloatValues);
        List<Double> oldDoubles = Collections.unmodifiableList(observedDoubleValues);
        List<String> oldClasses = Collections.unmodifiableList(instanceOfOrCastClasses);
        List<RecordedValues.FailedNullCheck> oldFailedNullChecks = Collections.unmodifiableList(failedNullChecks);
        Set<CharSequence> oldRegexInputValues = Collections.unmodifiableSet(observedRegexInputValues);
        observedStringValues = null;
        observedPatternValues = null;
        observedIntValues = null;
        observedFloatValues = null;
        observedDoubleValues = null;
        instanceOfOrCastClasses = null;
        failedNullChecks = null;
        observedRegexInputValues = null;
        return new RecordedValues(oldStrings, oldPatterns, oldIntegers, oldFloats, oldDoubles, oldClasses, arrayLengthRead, nullTestFound, oldFailedNullChecks, oldRegexInputValues);
    }

    private static boolean shouldRecordValueFoundInClass(Class<?> given) {
        SingleRowBooleanCache.Value cachedValue = cacheForShouldRecordValueFoundInClass.get(given);
        if (cachedValue != SingleRowBooleanCache.Value.Missed) {
            return cachedValue.getBoolean();
        }
        ClassToRecord currentRecordValuesForClass = recordValuesForClass;
        if (currentRecordValuesForClass == null) {
            return false;
        }
        ClassToRecord givenInfo = new ClassToRecord(given);
        boolean result = givenInfo.package1 != null && givenInfo.package2 != null ? givenInfo.package1.equals(currentRecordValuesForClass.package1) && givenInfo.package2.equals(currentRecordValuesForClass.package2) : given == currentRecordValuesForClass.aClass;
        cacheForShouldRecordValueFoundInClass.add(given, result);
        return result;
    }

    private static boolean strictShouldRecordValueFoundInClass(Class<?> given) {
        return recordValuesForClass != null && given == Runtime.recordValuesForClass.aClass;
    }

    public static void recordStringValue(String string, Class<?> foundInClass) {
        if (observedStringValues == null || !Runtime.shouldRecordValueFoundInClass(foundInClass)) {
            return;
        }
        observedStringValues.add(string);
    }

    public static void recordPatternValue(Pattern pattern) {
        if (observedPatternValues == null) {
            return;
        }
        observedPatternValues.add(pattern);
    }

    public static void recordPatternValue(String pattern) {
        if (pattern != null) {
            Runtime.recordPatternValue(Pattern.compile(pattern));
        }
    }

    public static void recordRegexInputForMatches(CharSequence input, boolean result) {
        if (observedRegexInputValues == null || input == null) {
            return;
        }
        String recordedRegexInput = result ? input.toString() : null;
        observedRegexInputValues.add(recordedRegexInput);
    }

    public static void recordRegexInputForMatcher(Pattern pattern, CharSequence input) {
        if (pattern == null) {
            return;
        }
        try {
            Field field = Pattern.class.getField("pattern");
            String patternStr = (String)field.get(pattern);
            Runtime.recordRegexInputForMatches(input, Pattern.compile(patternStr).matcher(input).find());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void recordRegexInputForReplace(String input, String replacement, String result) {
        if (observedRegexInputValues == null || input == null || replacement == null || result == null) {
            return;
        }
        String recordedRegexInput = result.equals(input) ? "" : input + replacement;
        observedRegexInputValues.add(recordedRegexInput);
    }

    public static void recordIntegerValue(int i, Class<?> foundInClass) {
        if (observedIntValues == null || observedIntValues.size() >= 50 || !Runtime.shouldRecordValueFoundInClass(foundInClass)) {
            return;
        }
        observedIntValues.add(i);
    }

    public static void recordFloatValue(float f, Class<?> foundInClass) {
        if (observedFloatValues == null || observedFloatValues.size() >= 50 || !Runtime.shouldRecordValueFoundInClass(foundInClass)) {
            return;
        }
        observedFloatValues.add(Float.valueOf(f));
    }

    public static void recordDoubleValue(double d, Class<?> foundInClass) {
        if (observedDoubleValues == null || observedDoubleValues.size() >= 50 || !Runtime.shouldRecordValueFoundInClass(foundInClass)) {
            return;
        }
        observedDoubleValues.add(d);
    }

    public static void recordClassReference(String cname, Class<?> foundInClass) {
        if (instanceOfOrCastClasses == null || !Runtime.shouldRecordValueFoundInClass(foundInClass) || instanceOfOrCastClasses.size() >= 50) {
            return;
        }
        instanceOfOrCastClasses.add(cname);
    }

    public static void recordArrayLengthOp(Class<?> foundInClass) {
        if (observedIntValues == null || !Runtime.shouldRecordValueFoundInClass(foundInClass)) {
            return;
        }
        arrayLengthRead = true;
    }

    public static void recordNullTest(Class<?> foundInClass) {
        if (observedIntValues == null || !Runtime.strictShouldRecordValueFoundInClass(foundInClass)) {
            return;
        }
        nullTestFound = true;
    }

    public static void checkNotNull(Object maybeNull, Class<?> foundInClass, String owner, String member, String desc) {
        if (maybeNull != null) {
            return;
        }
        if (observedIntValues == null || !Runtime.shouldRecordValueFoundInClass(foundInClass)) {
            return;
        }
        failedNullChecks.add(new RecordedValues.FailedNullCheck(owner, member, desc));
    }

    public static void recordWrite(Object obj, String field) {
        Set<Access> originalWrites = writes;
        if (originalWrites != null && Runtime.dontSkipWrite(obj)) {
            originalWrites.add(new Access(obj, field));
        }
    }

    public static void recordArrayWrite(Object obj, int idx) {
        Set<Access> originalWrites = writes;
        if (originalWrites != null && Runtime.dontSkipWrite(obj)) {
            originalWrites.add(new Access(obj, Integer.toString(idx)));
        }
    }

    public static void recordArrayWrite(Object src, int position, int length) {
        for (int i = 0; i < length; ++i) {
            Runtime.recordArrayWrite(src, position + i);
        }
    }

    public static void startRecordingReads() {
        if (recordingsInProgress++ == 0) {
            Runtime.resetRedirects();
            knownNew = new IdentityHashMap();
        }
        reads = new LinkedHashSet<Access>();
        AgentLogging.trace("Starting read recording", new Object[0]);
    }

    public static Set<Access> stopRecordingReads() {
        Set<Access> oldReads = reads != null ? Collections.unmodifiableSet(reads) : null;
        reads = null;
        if (--recordingsInProgress <= 0) {
            recordingsInProgress = 0;
            knownNew = null;
            whitelistToRead = null;
        }
        AgentLogging.trace("Stopping read recording, read set pointer is %x", System.identityHashCode(oldReads));
        return oldReads;
    }

    public static void recordRead(Object obj, String field) {
        Set<Access> originalReads = reads;
        if (originalReads != null && Runtime.dontSkipRead(obj)) {
            originalReads.add(new Access(obj, field));
        }
    }

    public static void recordArrayRead(Object obj, int idx) {
        Set<Access> originalReads = reads;
        if (originalReads != null && Runtime.dontSkipRead(obj)) {
            originalReads.add(new Access(obj, Integer.toString(idx)));
        }
    }

    public static void recordArrayRead(Object src, int position, int length) {
        for (int i = 0; i < length; ++i) {
            Runtime.recordArrayRead(src, position + i);
        }
    }

    private static boolean dontSkipWrite(Object obj) {
        if (whitelistToWrite != null && !whitelistToWrite.containsKey(obj)) {
            return false;
        }
        return knownNew == null || !knownNew.containsKey(obj);
    }

    private static boolean dontSkipRead(Object obj) {
        if (whitelistToRead != null && !whitelistToRead.containsKey(obj)) {
            return false;
        }
        return knownNew == null || !knownNew.containsKey(obj);
    }

    public static void recordNew(Object obj) {
        IdentityHashMap<Object, Void> originalKnownNew = knownNew;
        if (originalKnownNew != null) {
            originalKnownNew.put(obj, null);
        }
    }

    public static void tryLog(String fmt, Object ... args) {
        if (logToStderr) {
            System.err.printf(fmt, args);
        }
    }

    public static void setLogToStderr(boolean logToStderr) {
        Runtime.logToStderr = logToStderr;
        Runtime.tryLog("Enabled logging\n", new Object[0]);
    }

    static <T> T recordVirtualAlias(T view, Object base) {
        if (recordingsInProgress > 0) {
            assert (virtualAliases != null) : "r/w runtime - virtual aliases is null";
            Object target = Runtime.getTarget(base);
            if (target != null) {
                virtualAliases.put(view, target);
            }
        }
        return view;
    }

    private static Object getTarget(Object that) {
        assert (virtualAliases != null) : "r/w runtime - virtual aliases is null";
        return virtualAliases.getOrDefault(that, that);
    }

    static void recordVirtualWrite(Object that) {
        if (writes != null) {
            Object target = Runtime.getTarget(that);
            Runtime.recordWrite(target, "<data>");
        }
    }

    static void recordVirtualRead(Object that) {
        if (reads != null) {
            Object target = Runtime.getTarget(that);
            Runtime.recordRead(target, "<data>");
        }
    }

    static void onStringEquals(String str1, String str2, Class<?> callingClass) {
        if (observedStringValues == null || !Runtime.shouldRecordValueFoundInClass(callingClass)) {
            return;
        }
        if (str1 != null) {
            observedStringValues.add(str1);
        }
        if (str2 != null) {
            observedStringValues.add(str2);
        }
    }

    public static void resetRedirects() {
        virtualAliases.clear();
    }

    static {
        logObservedValues = false;
        recordingsInProgress = 0;
        cacheForShouldRecordValueFoundInClass = new SingleRowBooleanCache();
    }

    public static class ClassToRecord {
        public final Class<?> aClass;
        public final String package1;
        public final String package2;

        public ClassToRecord(Class<?> aClass) {
            this.aClass = aClass;
            String className = aClass.getName();
            int firstDot = className.indexOf(46);
            if (firstDot == -1) {
                this.package1 = null;
                this.package2 = null;
            } else {
                this.package1 = className.substring(0, firstDot);
                int secondDot = className.indexOf(46, firstDot + 1);
                this.package2 = secondDot == -1 ? null : className.substring(firstDot + 1, secondDot);
            }
        }
    }

    static class SingleRowBooleanCache<T> {
        private T key = null;
        private Value value = Value.Missed;
        private final Object mutex = new Object();

        SingleRowBooleanCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(T entry, boolean value) {
            Object object = this.mutex;
            synchronized (object) {
                this.key = entry;
                this.value = value ? Value.True : Value.False;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Value get(T key) {
            Object object = this.mutex;
            synchronized (object) {
                return key == this.key ? this.value : Value.Missed;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.key = null;
                this.value = Value.Missed;
            }
        }

        public static enum Value {
            True{

                @Override
                boolean getBoolean() {
                    return true;
                }
            }
            ,
            False{

                @Override
                boolean getBoolean() {
                    return false;
                }
            }
            ,
            Missed{

                @Override
                boolean getBoolean() {
                    throw new IllegalArgumentException();
                }
            };


            abstract boolean getBoolean();
        }
    }

    public static class RecordedValues {
        public List<Integer> intValues;
        public List<String> stringValues;
        public List<Pattern> patternValues;
        public List<Float> floatValues;
        public List<Double> doubleValues;
        public List<String> instanceOfOrCastClasses;
        public boolean arrayLengthRead;
        public boolean nullTestFound;
        public List<FailedNullCheck> failedNullChecks;
        public Set<CharSequence> regexInputValues;

        public RecordedValues(List<String> stringValues, List<Pattern> patternValues, List<Integer> intValues, List<Float> floatValues, List<Double> doubleValues, List<String> instanceOfOrCastClasses, boolean arrayLengthRead, boolean nullTestFound, List<FailedNullCheck> failedNullChecks, Set<CharSequence> regexInputValues) {
            this.intValues = intValues;
            this.stringValues = stringValues;
            this.patternValues = patternValues;
            this.floatValues = floatValues;
            this.doubleValues = doubleValues;
            this.instanceOfOrCastClasses = instanceOfOrCastClasses;
            this.arrayLengthRead = arrayLengthRead;
            this.nullTestFound = nullTestFound;
            this.failedNullChecks = failedNullChecks;
            this.regexInputValues = regexInputValues;
        }

        private static String listToString(List<?> list) {
            return list.stream().map(Object::toString).collect(Collectors.joining(", "));
        }

        public void print() {
            if (logObservedValues) {
                if (!this.intValues.isEmpty()) {
                    System.err.println("Encountered int values: " + RecordedValues.listToString(this.intValues));
                    if (!this.patternValues.isEmpty()) {
                        System.err.println("Encountered pattern values: " + RecordedValues.listToString(this.patternValues));
                    }
                }
                if (!this.stringValues.isEmpty()) {
                    System.err.println("Encountered string values: " + RecordedValues.listToString(this.stringValues));
                }
                if (!this.floatValues.isEmpty()) {
                    System.err.println("Encountered float values: " + RecordedValues.listToString(this.floatValues));
                }
                if (!this.doubleValues.isEmpty()) {
                    System.err.println("Encountered double values: " + RecordedValues.listToString(this.doubleValues));
                }
                if (!this.instanceOfOrCastClasses.isEmpty()) {
                    System.err.println("Encountered class references: " + RecordedValues.listToString(this.instanceOfOrCastClasses));
                }
                if (this.arrayLengthRead) {
                    System.err.println("Encountered an array-length read");
                }
                if (this.nullTestFound) {
                    System.err.println("Encountered a null test");
                }
                if (!this.failedNullChecks.isEmpty()) {
                    System.err.println("Encountered failed null checks: " + RecordedValues.listToString(this.failedNullChecks));
                }
                if (!this.regexInputValues.isEmpty()) {
                    System.err.println("Encountered regex input values: " + RecordedValues.listToString(new ArrayList<CharSequence>(this.regexInputValues)));
                }
            }
        }

        public static class FailedNullCheck {
            public String owner;
            public String member;
            public String desc;

            public FailedNullCheck(String owner, String member, String desc) {
                this.owner = owner;
                this.member = member;
                this.desc = desc;
            }

            public boolean isField() {
                return this.desc == null;
            }

            public String toString() {
                return this.desc == null ? "Field " + this.owner + "." + this.member : "Method return " + this.owner + "." + this.member + ":" + this.desc;
            }
        }
    }
}

