/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api;

import java.util.function.Consumer;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Appendable;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.ChildElement;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Context;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Factory;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.Namespace;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.QualifiedName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class Element<T extends Element<T>>
implements Appendable<T> {
    private final Context context;
    private final Namespace namespace;
    final org.w3c.dom.Element domElement;

    public Element(Context context, QualifiedName qualifiedName) {
        this.context = context;
        this.namespace = qualifiedName.getNamespace();
        this.domElement = context.createElement(qualifiedName);
    }

    org.w3c.dom.Element getDomElement() {
        return this.domElement;
    }

    public Element<T> withContent(String value) {
        this.domElement.setTextContent(value);
        return this;
    }

    public Element<T> withCDataSection(String value) {
        this.domElement.appendChild(this.document().createCDATASection(value));
        return this;
    }

    public Element<T> withAttribute(QualifiedName qualifiedName, String value) {
        Attr attr = this.createAttr(qualifiedName);
        attr.setValue(value);
        this.domElement.setAttributeNode(attr);
        return this;
    }

    private Attr createAttr(QualifiedName qualifiedName) {
        return this.namespace.equals(qualifiedName.getNamespace()) ? this.document().createAttribute(qualifiedName.getSimpleName()) : this.document().createAttributeNS(qualifiedName.getNamespace().getUri(), this.context.prefixed(qualifiedName));
    }

    private Document document() {
        return this.context.getDocument();
    }

    @Override
    public <C extends ChildElement<T, ? super C>> Appendable<T> append(Factory<C> creator, Consumer<? super C> configurer) {
        ChildElement child = (ChildElement)creator.createAndConfigure(this.context, configurer);
        this.domElement.appendChild(child.domElement);
        return this;
    }

    public String toString() {
        return "Element{domElement=" + this.domElement + '}';
    }
}

