/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners.discovery;

import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.SelectorResolutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.launcher.EngineDiscoveryResult;
import org.junit.platform.launcher.LauncherDiscoveryListener;

class AbortOnFailureLauncherDiscoveryListener
implements LauncherDiscoveryListener {
    AbortOnFailureLauncherDiscoveryListener() {
    }

    @Override
    public void engineDiscoveryFinished(UniqueId engineId, EngineDiscoveryResult result) {
        result.getThrowable().ifPresent(ExceptionUtils::throwAsUncheckedException);
    }

    @Override
    public void selectorProcessed(UniqueId engineId, DiscoverySelector selector, SelectorResolutionResult result) {
        UniqueId uniqueId;
        if (result.getStatus() == SelectorResolutionResult.Status.FAILED) {
            throw new JUnitException(selector + " resolution failed", result.getThrowable().orElse(null));
        }
        if (result.getStatus() == SelectorResolutionResult.Status.UNRESOLVED && selector instanceof UniqueIdSelector && (uniqueId = ((UniqueIdSelector)selector).getUniqueId()).hasPrefix(engineId)) {
            throw new JUnitException(selector + " could not be resolved");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        return 0;
    }
}

