/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.OutputDir;

@API(status=API.Status.EXPERIMENTAL, since="1.8")
public class UniqueIdTrackingListener
implements TestExecutionListener {
    public static final String LISTENER_ENABLED_PROPERTY_NAME = "junit.platform.listeners.uid.tracking.enabled";
    public static final String OUTPUT_DIR_PROPERTY_NAME = "junit.platform.listeners.uid.tracking.output.dir";
    public static final String OUTPUT_FILE_PREFIX_PROPERTY_NAME = "junit.platform.listeners.uid.tracking.output.file.prefix";
    public static final String DEFAULT_OUTPUT_FILE_PREFIX = "junit-platform-unique-ids";
    private final Logger logger = LoggerFactory.getLogger(UniqueIdTrackingListener.class);
    private final List<String> uniqueIds = new ArrayList<String>();
    private boolean enabled;

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.enabled = testPlan.getConfigurationParameters().getBoolean(LISTENER_ENABLED_PROPERTY_NAME).orElse(false);
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.trackTestUid(testIdentifier);
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.trackTestUid(testIdentifier);
    }

    private void trackTestUid(TestIdentifier testIdentifier) {
        if (this.enabled && testIdentifier.isTest()) {
            this.uniqueIds.add(testIdentifier.getUniqueId());
        }
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        if (this.enabled) {
            Path outputFile;
            try {
                outputFile = this.createOutputFile(testPlan.getConfigurationParameters());
            }
            catch (Exception ex) {
                this.logger.error(ex, () -> "Failed to create output file");
                return;
            }
            this.logger.debug(() -> "Writing unique IDs to output file " + outputFile.toAbsolutePath());
            try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, new OpenOption[0]));){
                this.uniqueIds.forEach(writer::println);
                writer.flush();
            }
            catch (IOException ex) {
                this.logger.error(ex, () -> "Failed to write unique IDs to output file " + outputFile.toAbsolutePath());
            }
        }
    }

    private Path createOutputFile(ConfigurationParameters configurationParameters) {
        String prefix = configurationParameters.get(OUTPUT_FILE_PREFIX_PROPERTY_NAME).orElse(DEFAULT_OUTPUT_FILE_PREFIX);
        return OutputDir.create(configurationParameters.get(OUTPUT_DIR_PROPERTY_NAME)).createFile(prefix, "txt");
    }
}

