/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.console.shadow.picocli.CommandLine;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UriSelector;

class SelectorConverter {
    SelectorConverter() {
    }

    static class Iteration
    implements CommandLine.ITypeConverter<IterationSelector> {
        public static final Pattern PATTERN = Pattern.compile("(?<type>[a-z]+):(?<value>.*)\\[(?<indices>(\\d+)(\\.\\.\\d+)?(\\s*,\\s*(\\d+)(\\.\\.\\d+)?)*)]");

        Iteration() {
        }

        @Override
        public IterationSelector convert(String value) {
            Matcher matcher = PATTERN.matcher(value);
            Preconditions.condition(matcher.matches(), "Invalid format: must be TYPE:VALUE[INDEX(,INDEX)*]");
            DiscoverySelector parentSelector = this.createParentSelector(matcher.group("type"), matcher.group("value"));
            int[] iterationIndices = Arrays.stream(matcher.group("indices").split(",")).flatMapToInt(this::parseIndexDefinition).toArray();
            return DiscoverySelectors.selectIteration(parentSelector, iterationIndices);
        }

        private IntStream parseIndexDefinition(String value) {
            String[] parts = value.split("\\.\\.", 2);
            int firstIndex = Integer.parseInt(parts[0]);
            if (parts.length == 2) {
                int lastIndex = Integer.parseInt(parts[1]);
                return IntStream.rangeClosed(firstIndex, lastIndex);
            }
            return IntStream.of(firstIndex);
        }

        private DiscoverySelector createParentSelector(String type, String value) {
            switch (type) {
                case "module": {
                    return DiscoverySelectors.selectModule(value);
                }
                case "uri": {
                    return DiscoverySelectors.selectUri(value);
                }
                case "file": {
                    return DiscoverySelectors.selectFile(value);
                }
                case "directory": {
                    return DiscoverySelectors.selectDirectory(value);
                }
                case "package": {
                    return DiscoverySelectors.selectPackage(value);
                }
                case "class": {
                    return DiscoverySelectors.selectClass(value);
                }
                case "method": {
                    return DiscoverySelectors.selectMethod(value);
                }
                case "resource": {
                    return DiscoverySelectors.selectClasspathResource(value);
                }
            }
            throw new IllegalArgumentException("Unknown type: " + type);
        }
    }

    static class ClasspathResource
    implements CommandLine.ITypeConverter<ClasspathResourceSelector> {
        ClasspathResource() {
        }

        @Override
        public ClasspathResourceSelector convert(String value) {
            return DiscoverySelectors.selectClasspathResource(value);
        }
    }

    static class Method
    implements CommandLine.ITypeConverter<MethodSelector> {
        Method() {
        }

        @Override
        public MethodSelector convert(String value) {
            return DiscoverySelectors.selectMethod(value);
        }
    }

    static class Class
    implements CommandLine.ITypeConverter<ClassSelector> {
        Class() {
        }

        @Override
        public ClassSelector convert(String value) {
            return DiscoverySelectors.selectClass(value);
        }
    }

    static class Package
    implements CommandLine.ITypeConverter<PackageSelector> {
        Package() {
        }

        @Override
        public PackageSelector convert(String value) {
            return DiscoverySelectors.selectPackage(value);
        }
    }

    static class Directory
    implements CommandLine.ITypeConverter<DirectorySelector> {
        Directory() {
        }

        @Override
        public DirectorySelector convert(String value) {
            return DiscoverySelectors.selectDirectory(value);
        }
    }

    static class File
    implements CommandLine.ITypeConverter<FileSelector> {
        File() {
        }

        @Override
        public FileSelector convert(String value) {
            return DiscoverySelectors.selectFile(value);
        }
    }

    static class Uri
    implements CommandLine.ITypeConverter<UriSelector> {
        Uri() {
        }

        @Override
        public UriSelector convert(String value) {
            return DiscoverySelectors.selectUri(value);
        }
    }

    static class Module
    implements CommandLine.ITypeConverter<ModuleSelector> {
        Module() {
        }

        @Override
        public ModuleSelector convert(String value) {
            return DiscoverySelectors.selectModule(value);
        }
    }
}

