/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class MethodArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<MethodSource> {
    private String[] methodNames;

    MethodArgumentsProvider() {
    }

    @Override
    public void accept(MethodSource annotation) {
        this.methodNames = annotation.value();
    }

    public Stream<Arguments> provideArguments(ExtensionContext context) {
        Object testInstance = context.getTestInstance().orElse(null);
        return Arrays.stream(this.methodNames).map(factoryMethodName -> this.getFactoryMethod(context, (String)factoryMethodName)).map(factoryMethod -> context.getExecutableInvoker().invoke((Method)factoryMethod, (Object)testInstance)).flatMap(CollectionUtils::toStream).map(MethodArgumentsProvider::toArguments);
    }

    private Method getFactoryMethod(ExtensionContext context, String factoryMethodName) {
        Method testMethod = context.getRequiredTestMethod();
        if (StringUtils.isBlank(factoryMethodName)) {
            factoryMethodName = testMethod.getName();
        }
        if (MethodArgumentsProvider.looksLikeAFullyQualifiedMethodName(factoryMethodName)) {
            return this.getFactoryMethodByFullyQualifiedName(factoryMethodName);
        }
        return this.getFactoryMethodBySimpleOrQualifiedName(context.getRequiredTestClass(), testMethod, factoryMethodName);
    }

    private static boolean looksLikeAFullyQualifiedMethodName(String factoryMethodName) {
        if (factoryMethodName.contains("#")) {
            return true;
        }
        int indexOfDot = factoryMethodName.indexOf(".");
        if (indexOfDot == -1) {
            return false;
        }
        int indexOfOpeningParenthesis = factoryMethodName.indexOf("(");
        if (indexOfOpeningParenthesis > 0) {
            return indexOfDot < indexOfOpeningParenthesis;
        }
        return true;
    }

    private Method getFactoryMethodByFullyQualifiedName(String fullyQualifiedMethodName) {
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName(fullyQualifiedMethodName);
        String className = methodParts[0];
        String methodName = methodParts[1];
        String methodParameters = methodParts[2];
        return ReflectionUtils.findMethod(this.loadRequiredClass(className), methodName, methodParameters).orElseThrow(() -> new JUnitException(String.format("Could not find factory method [%s(%s)] in class [%s]", methodName, methodParameters, className)));
    }

    private Method getFactoryMethodBySimpleOrQualifiedName(Class<?> testClass, Method testMethod, String simpleOrQualifiedMethodName) {
        String[] methodParts = ReflectionUtils.parseQualifiedMethodName(simpleOrQualifiedMethodName);
        String methodSimpleName = methodParts[0];
        String methodParameters = methodParts[1];
        List<Method> factoryMethods = this.findFactoryMethodsBySimpleName(testClass, testMethod, methodSimpleName);
        if (factoryMethods.size() == 1) {
            return factoryMethods.get(0);
        }
        List<Method> exactMatches = MethodArgumentsProvider.filterFactoryMethodsWithMatchingParameters(factoryMethods, simpleOrQualifiedMethodName, methodParameters);
        Preconditions.condition(exactMatches.size() == 1, () -> String.format("%d factory methods named [%s] were found in class [%s]: %s", factoryMethods.size(), simpleOrQualifiedMethodName, testClass.getName(), factoryMethods));
        return exactMatches.get(0);
    }

    private List<Method> findFactoryMethodsBySimpleName(Class<?> testClass, Method testMethod, String factoryMethodName) {
        Predicate<Method> isCandidate = candidate -> factoryMethodName.equals(candidate.getName()) && !testMethod.equals(candidate);
        List<Method> candidates = ReflectionUtils.findMethods(testClass, isCandidate);
        Predicate<Method> isFactoryMethod = method -> CollectionUtils.isConvertibleToStream(method.getReturnType()) && !this.isTestMethod((Method)method);
        List<Method> factoryMethods = candidates.stream().filter(isFactoryMethod).collect(Collectors.toList());
        Preconditions.condition(factoryMethods.size() > 0, () -> {
            if (candidates.size() > 0) {
                return String.format("Could not find valid factory method [%s] in class [%s] but found the following invalid candidates: %s", factoryMethodName, testClass.getName(), candidates);
            }
            return String.format("Could not find factory method [%s] in class [%s]", factoryMethodName, testClass.getName());
        });
        return factoryMethods;
    }

    private static List<Method> filterFactoryMethodsWithMatchingParameters(List<Method> factoryMethods, String factoryMethodName, String factoryMethodParameters) {
        if (!factoryMethodName.endsWith(")")) {
            return factoryMethods;
        }
        String parameterList = factoryMethodParameters.replaceAll("\\s+", "");
        Predicate<Method> hasRequiredParameters = method -> {
            if (parameterList.isEmpty()) {
                return method.getParameterCount() == 0;
            }
            return parameterList.equals(Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(Collectors.joining(",")));
        };
        return factoryMethods.stream().filter(hasRequiredParameters).collect(Collectors.toList());
    }

    private boolean isTestMethod(Method candidate) {
        return AnnotationUtils.isAnnotated(candidate, Test.class) || AnnotationUtils.isAnnotated(candidate, TestTemplate.class) || AnnotationUtils.isAnnotated(candidate, TestFactory.class);
    }

    private Class<?> loadRequiredClass(String className) {
        return ReflectionUtils.tryToLoadClass(className).getOrThrow(cause -> new JUnitException(String.format("Could not load class [%s]", className), (Throwable)cause));
    }

    private static Arguments toArguments(Object item) {
        if (item instanceof Arguments) {
            return (Arguments)item;
        }
        if (ReflectionUtils.isMultidimensionalArray(item)) {
            return Arguments.arguments(item);
        }
        if (item instanceof Object[]) {
            return Arguments.arguments((Object[])item);
        }
        return Arguments.arguments(item);
    }
}

