/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.execution.ExtensionValuesStore;
import org.junit.jupiter.engine.execution.NamespaceAwareStore;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.hierarchical.Node;

abstract class AbstractExtensionContext<T extends TestDescriptor>
implements ExtensionContext,
AutoCloseable {
    private final ExtensionContext parent;
    private final EngineExecutionListener engineExecutionListener;
    private final T testDescriptor;
    private final Set<String> tags;
    private final JupiterConfiguration configuration;
    private final ExtensionValuesStore valuesStore;
    private final ExecutableInvoker executableInvoker;

    AbstractExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, T testDescriptor, JupiterConfiguration configuration, ExecutableInvoker executableInvoker) {
        this.executableInvoker = executableInvoker;
        Preconditions.notNull(testDescriptor, "TestDescriptor must not be null");
        Preconditions.notNull(configuration, "JupiterConfiguration must not be null");
        this.parent = parent;
        this.engineExecutionListener = engineExecutionListener;
        this.testDescriptor = testDescriptor;
        this.configuration = configuration;
        this.valuesStore = this.createStore(parent);
        this.tags = testDescriptor.getTags().stream().map(TestTag::getName).collect(Collectors.collectingAndThen(Collectors.toCollection(LinkedHashSet::new), Collections::unmodifiableSet));
    }

    private ExtensionValuesStore createStore(ExtensionContext parent) {
        ExtensionValuesStore parentStore = null;
        if (parent != null) {
            parentStore = ((AbstractExtensionContext)parent).valuesStore;
        }
        return new ExtensionValuesStore(parentStore);
    }

    @Override
    public void close() {
        this.valuesStore.closeAllStoredCloseableValues();
    }

    @Override
    public String getUniqueId() {
        return this.getTestDescriptor().getUniqueId().toString();
    }

    @Override
    public String getDisplayName() {
        return this.getTestDescriptor().getDisplayName();
    }

    @Override
    public void publishReportEntry(Map<String, String> values) {
        this.engineExecutionListener.reportingEntryPublished((TestDescriptor)this.testDescriptor, ReportEntry.from(values));
    }

    @Override
    public Optional<ExtensionContext> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public ExtensionContext getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    protected T getTestDescriptor() {
        return this.testDescriptor;
    }

    @Override
    public ExtensionContext.Store getStore(ExtensionContext.Namespace namespace) {
        Preconditions.notNull(namespace, "Namespace must not be null");
        return new NamespaceAwareStore(this.valuesStore, namespace);
    }

    @Override
    public Set<String> getTags() {
        return new LinkedHashSet<String>(this.tags);
    }

    @Override
    public Optional<String> getConfigurationParameter(String key) {
        return this.configuration.getRawConfigurationParameter(key);
    }

    public <V> Optional<V> getConfigurationParameter(String key, Function<String, V> transformer) {
        return this.configuration.getRawConfigurationParameter(key, transformer);
    }

    @Override
    public ExecutionMode getExecutionMode() {
        return this.toJupiterExecutionMode(this.getPlatformExecutionMode());
    }

    @Override
    public ExecutableInvoker getExecutableInvoker() {
        return this.executableInvoker;
    }

    protected abstract Node.ExecutionMode getPlatformExecutionMode();

    private ExecutionMode toJupiterExecutionMode(Node.ExecutionMode mode) {
        switch (mode) {
            case CONCURRENT: {
                return ExecutionMode.CONCURRENT;
            }
            case SAME_THREAD: {
                return ExecutionMode.SAME_THREAD;
            }
        }
        throw new JUnitException("Unknown ExecutionMode: " + (Object)((Object)mode));
    }
}

