/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.ant.tasks;

import com.diffblue.cover.buildsystem.ant.types.AntVersionType;
import com.diffblue.cover.buildsystem.ant.types.BuildDirectoryType;
import com.diffblue.cover.buildsystem.ant.types.ClasspathType;
import com.diffblue.cover.buildsystem.ant.types.ComplianceLevelType;
import com.diffblue.cover.buildsystem.ant.types.EncodingType;
import com.diffblue.cover.buildsystem.ant.types.JacocoDestFileType;
import com.diffblue.cover.buildsystem.ant.types.JacocoFormatsType;
import com.diffblue.cover.buildsystem.ant.types.JacocoReportType;
import com.diffblue.cover.buildsystem.ant.types.JunitReportType;
import com.diffblue.cover.buildsystem.ant.types.LocationType;
import com.diffblue.cover.buildsystem.ant.types.ModuleNameType;
import com.diffblue.cover.buildsystem.ant.types.ProductionClassesType;
import com.diffblue.cover.buildsystem.ant.types.ProductionSourcesType;
import com.diffblue.cover.buildsystem.ant.types.SubmoduleType;
import com.diffblue.cover.buildsystem.ant.types.TestClassesType;
import com.diffblue.cover.buildsystem.ant.types.TestSourcesType;
import com.diffblue.cover.buildsystem.ant.utils.ProjectModuleTaskMessageAdapter;
import com.diffblue.cover.buildsystem.model.DefaultProjectModuleMessage;
import com.diffblue.cover.buildsystem.serialization.Utils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class AntProjectModuleTask
extends Task {
    private ModuleNameType moduleName;
    private LocationType projectLocation;
    private ClasspathType classpath;
    private ProductionClassesType productionClasses;
    private ProductionSourcesType productionSources;
    private BuildDirectoryType buildDirectory;
    private JacocoDestFileType jacocoDestFile;
    private JacocoReportType jacocoReport;
    private JunitReportType junitReport;
    private JacocoFormatsType jacocoFormats;
    private ComplianceLevelType complianceLevel;
    private TestSourcesType testSources;
    private TestClassesType testClasses;
    private AntVersionType version;
    private EncodingType encoding;
    private SubmoduleType submodules = new SubmoduleType();

    public void execute() {
        this.validateProjectModule(this);
        Utils.writeMessage(new DefaultProjectModuleMessage(ProjectModuleTaskMessageAdapter.adapt(this)), (s, e) -> {});
    }

    private void validateProjectModule(AntProjectModuleTask task) {
        if (task.moduleName == null || task.moduleName.isEmpty()) {
            throw new BuildException("moduleName is not set or is empty", this.getLocation());
        }
        if (task.projectLocation == null) {
            throw new BuildException("module: " + (Object)((Object)task.moduleName) + ", projectLocation is not set or is empty", this.getLocation());
        }
        if (task.submodules != null && !task.submodules.getSubmodules().isEmpty()) {
            task.submodules.getSubmodules().forEach(this::validateProjectModule);
        } else {
            if (task.classpath == null || task.classpath.isEmpty()) {
                throw new BuildException("module: " + (Object)((Object)task.moduleName) + ", classpath is not set or is empty", this.getLocation());
            }
            if (task.productionSources == null || task.productionSources.isEmpty()) {
                throw new BuildException("module: " + (Object)((Object)task.moduleName) + ", productionSources is not set or is empty", this.getLocation());
            }
            if (task.productionClasses == null) {
                throw new BuildException("module: " + (Object)((Object)task.moduleName) + ", productionClasses is not set or is empty", this.getLocation());
            }
            if (task.buildDirectory == null) {
                throw new BuildException("module: " + (Object)((Object)task.moduleName) + ", buildDirectory is not set or is empty", this.getLocation());
            }
            if (task.jacocoDestFile == null || task.jacocoDestFile.isEmpty()) {
                throw new BuildException("module: " + (Object)((Object)task.moduleName) + ", jacocoDestFile is not set or is empty", this.getLocation());
            }
            if (task.jacocoReport == null || task.jacocoReport.isEmpty()) {
                throw new BuildException("module: " + (Object)((Object)task.moduleName) + ", jacocoReport is not set or is empty", this.getLocation());
            }
        }
    }

    public String getModuleName() {
        return this.moduleName.getModuleName();
    }

    @Nullable
    public File getProjectLocation() {
        if (this.projectLocation == null) {
            return null;
        }
        return this.firstOf(this.projectLocation.list()).orElse(null);
    }

    @Nullable
    public List<File> getClasspath() {
        if (this.classpath == null) {
            return null;
        }
        return this.allOf(this.classpath.list());
    }

    @Nullable
    public List<File> getProductionSources() {
        if (this.productionSources == null) {
            return null;
        }
        return this.allOf(this.productionSources.list());
    }

    @Nullable
    public File getProductionClasses() {
        if (this.productionClasses == null) {
            return null;
        }
        return this.firstOf(this.productionClasses.list()).orElse(null);
    }

    @Nullable
    public File getBuildDirectory() {
        if (this.buildDirectory == null) {
            return null;
        }
        return this.firstOf(this.buildDirectory.list()).orElse(null);
    }

    @Nullable
    public List<String> getJacocoDestFile() {
        if (this.jacocoDestFile == null) {
            return null;
        }
        return Arrays.asList(this.jacocoDestFile.list());
    }

    @Nullable
    public List<String> getJacocoReport() {
        if (this.jacocoReport == null) {
            return null;
        }
        return Arrays.asList(this.jacocoReport.list());
    }

    @Nullable
    public List<String> getJunitReport() {
        if (this.junitReport == null) {
            return null;
        }
        return Arrays.asList(this.junitReport.list());
    }

    @Nullable
    public List<String> getJacocoFormats() {
        if (this.jacocoFormats == null) {
            return null;
        }
        return Arrays.stream(this.jacocoFormats.getJacocoFormats().split(",")).collect(Collectors.toList());
    }

    @Nullable
    public String getComplianceLevel() {
        if (this.complianceLevel == null) {
            return null;
        }
        return this.complianceLevel.getComplianceLevel();
    }

    @Nullable
    public List<File> getTestSources() {
        if (this.testSources == null) {
            return null;
        }
        return this.allOf(this.testSources.list());
    }

    @Nullable
    public File getTestClasses() {
        if (this.testClasses == null) {
            return null;
        }
        return this.firstOf(this.testClasses.list()).orElse(null);
    }

    @Nullable
    public String getVersion() {
        if (this.version == null) {
            return null;
        }
        return this.version.getVersion();
    }

    @Nullable
    public String getEncoding() {
        if (this.encoding == null) {
            return null;
        }
        return this.encoding.getFileEncoding();
    }

    public SubmoduleType getSubmodules() {
        return this.submodules;
    }

    public void add(ModuleNameType moduleName) {
        this.moduleName = moduleName;
    }

    public void add(LocationType projectLocation) {
        this.projectLocation = projectLocation;
    }

    public void add(ClasspathType classpath) {
        this.classpath = classpath;
    }

    public void add(ProductionSourcesType productionSources) {
        this.productionSources = productionSources;
    }

    public void add(ProductionClassesType productionClasses) {
        this.productionClasses = productionClasses;
    }

    public void add(BuildDirectoryType buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    public void add(JacocoDestFileType jacocoDestFile) {
        this.jacocoDestFile = jacocoDestFile;
    }

    public void add(JacocoReportType jacocoReport) {
        this.jacocoReport = jacocoReport;
    }

    public void add(JunitReportType junitReport) {
        this.junitReport = junitReport;
    }

    public void add(JacocoFormatsType jacocoFormats) {
        this.jacocoFormats = jacocoFormats;
    }

    public void add(ComplianceLevelType complianceLevel) {
        this.complianceLevel = complianceLevel;
    }

    public void add(TestSourcesType testSources) {
        this.testSources = testSources;
    }

    public void add(TestClassesType testClasses) {
        this.testClasses = testClasses;
    }

    public void add(AntVersionType version) {
        this.version = version;
    }

    public void add(EncodingType encoding) {
        this.encoding = encoding;
    }

    public void add(SubmoduleType submodules) {
        this.submodules = submodules;
    }

    @Nonnull
    private List<File> allOf(String[] list) {
        return Arrays.stream(list).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toFile).collect(Collectors.toList());
    }

    @Nonnull
    private Optional<File> firstOf(String[] list) {
        return Arrays.stream(list).findFirst().map(x$0 -> Paths.get(x$0, new String[0])).map(Path::toFile);
    }
}

