/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.util;

import com.diffblue.cover.buildsystem.model.Plugin;
import com.diffblue.cover.buildsystem.model.ProjectModule;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PluginUtils {
    private PluginUtils() {
    }

    public static Optional<String> getPluginVersion(String groupId, String artifactId, ProjectModule model) {
        List<Plugin> plugins = model.getPlugins();
        if (plugins == null || plugins.isEmpty()) {
            return Optional.empty();
        }
        return plugins.stream().filter(plugin -> groupId.equals(plugin.getGroupId())).filter(plugin -> artifactId.equals(plugin.getArtefactId())).findFirst().map(Plugin::getVersion);
    }

    public static Optional<String> getPluginVersion(String pluginClassName, ProjectModule model) {
        List<Plugin> plugins = model.getPlugins();
        if (plugins == null || plugins.isEmpty()) {
            return Optional.empty();
        }
        return plugins.stream().filter(Objects::nonNull).filter(plugin -> plugin.getPluginClassName() != null).filter(plugin -> plugin.getPluginClassName().startsWith(pluginClassName)).findFirst().map(Plugin::getVersion);
    }
}

