/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.ant.utils;

import com.diffblue.cover.buildsystem.ant.tasks.AntProjectModuleTask;
import com.diffblue.cover.buildsystem.model.DefaultProjectModuleBuilder;
import com.diffblue.cover.buildsystem.model.ProjectModule;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ProjectModuleTaskMessageAdapter {
    private ProjectModuleTaskMessageAdapter() {
    }

    public static ProjectModule adapt(AntProjectModuleTask antProjectModule) {
        List<DefaultProjectModuleBuilder> submodules = antProjectModule.getSubmodules().getSubmodules().stream().map(ProjectModuleTaskMessageAdapter::createBuilder).collect(Collectors.toList());
        DefaultProjectModuleBuilder builder = ProjectModuleTaskMessageAdapter.createBuilder(antProjectModule);
        builder.setSubModules(submodules);
        return builder.build();
    }

    @Nonnull
    private static DefaultProjectModuleBuilder createBuilder(AntProjectModuleTask projectModule) {
        DefaultProjectModuleBuilder builder = new DefaultProjectModuleBuilder();
        builder.setFullName(projectModule.getModuleName()).setSimpleName(projectModule.getModuleName()).setBuildSystemName("ant").setBuildSystemVersion(projectModule.getVersion()).setLocation(projectModule.getProjectLocation()).setRuntimeClasspath(projectModule.getClasspath()).setProductionClasses(projectModule.getProductionClasses()).setProductionSourceDirectories(projectModule.getProductionSources()).setTestClasses(projectModule.getTestClasses()).setTestSourceDirectories(projectModule.getTestSources()).setJavaComplianceLevel(projectModule.getComplianceLevel()).setEncoding(projectModule.getEncoding()).setJunitReportDirectories(projectModule.getJunitReport()).setBuildDirectory(projectModule.getBuildDirectory()).setJacocoReportDirectories(projectModule.getJacocoReport()).setJacocoDestFile(projectModule.getJacocoDestFile()).setJacocoFormats(projectModule.getJacocoFormats()).setIsJacocoSkipped(false);
        return builder;
    }
}

