/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.ant.listeners;

import com.diffblue.cover.buildsystem.model.DefaultEventMessage;
import com.diffblue.cover.buildsystem.model.State;
import com.diffblue.cover.buildsystem.serialization.Utils;
import javax.annotation.Nonnull;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;

public class BuildEventListener
implements BuildListener {
    public void buildStarted(BuildEvent event) {
        this.logStartEvent(event);
    }

    public void buildFinished(BuildEvent event) {
        this.logFinishEvent(event);
    }

    public void targetStarted(BuildEvent event) {
        this.logStartEvent(event);
    }

    public void targetFinished(BuildEvent event) {
        this.logFinishEvent(event);
    }

    public void taskStarted(BuildEvent event) {
        this.logStartEvent(event);
    }

    public void taskFinished(BuildEvent event) {
        this.logFinishEvent(event);
    }

    public void messageLogged(BuildEvent event) {
    }

    private void logStartEvent(BuildEvent event) {
        this.logEvent(event, State.STARTED);
    }

    private void logFinishEvent(BuildEvent event) {
        this.logEvent(event, BuildEventListener.getState(event));
    }

    private void logEvent(BuildEvent event, State state) {
        Utils.writeMessage(new DefaultEventMessage(event.getProject().getName(), BuildEventListener.getEventName(event), event.getException(), state), (m, e) -> {});
    }

    @Nonnull
    private static State getState(BuildEvent event) {
        return event.getException() == null ? State.SUCCESS : State.ERROR;
    }

    @Nonnull
    private static String getEventName(BuildEvent event) {
        if (event.getTarget() == null) {
            return "build";
        }
        String targetName = event.getTarget().getName();
        if (event.getTask() == null) {
            return targetName;
        }
        String taskName = event.getTask().getTaskName();
        return targetName + "." + taskName;
    }
}

