/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.fuzztest.shared.proxy;

import com.diffblue.fuzztest.shared.proxy.spring.BeanSetInfo;
import java.util.stream.Collectors;

public class MissingBeanException
extends Exception {
    private final BeanSetInfo missingBeans;

    public MissingBeanException(BeanSetInfo missingBeans, Throwable cause) {
        super(cause);
        this.missingBeans = missingBeans;
    }

    public BeanSetInfo getMissingBeans() {
        return this.missingBeans;
    }

    @Override
    public String getMessage() {
        String classes = this.missingBeans.getBeanTypes().stream().map(Class::getName).collect(Collectors.joining(", "));
        String names = this.missingBeans.getNameOnlyBeans().stream().collect(Collectors.joining(", "));
        String message = "Missing bean types: " + classes;
        if (names.length() > 0) {
            message = message + " Name only beans: " + names;
        }
        return message;
    }
}

