/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.launcher;

import com.diffblue.cover.launcher.CoverClassLoader;
import com.diffblue.cover.launcher.LauncherException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;

public class Launcher {
    public static final String COVER_JAR_PATH_PROPERTY = "cover.jar.path";
    public static final String ENTRYPOINT_PROPERTY = "cover.main.class";

    public static void main(String[] args) {
        try {
            URL coverURL = Launcher.locateCoverJar();
            String entryPoint = Launcher.locateEntryPoint(coverURL);
            Launcher.invokeMainMethod(coverURL, entryPoint, args);
            System.exit(0);
        }
        catch (LauncherException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (Throwable e) {
            Launcher.dumpException(e, System.err);
            System.exit(1);
        }
    }

    public static void dumpException(Throwable e, PrintStream outStream) {
        outStream.printf("Unexpected exception of type %s!%n", e.getClass().getName());
        if (e.getMessage() != null) {
            outStream.printf("  %s%n", e.getMessage());
        }
        e.printStackTrace(outStream);
    }

    public static void invokeMainMethod(URL coverURL, String entryPoint, String[] args) throws Throwable {
        try (CoverClassLoader classLoader = new CoverClassLoader(new URL[]{coverURL});){
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> mainClass = null;
            try {
                mainClass = classLoader.loadClass(entryPoint);
            }
            catch (ClassNotFoundException e) {
                throw new LauncherException("Cannot find `%s' in `%s'!", entryPoint, coverURL);
            }
            Method mainMethod = null;
            try {
                mainMethod = mainClass.getMethod("main", String[].class);
            }
            catch (NoSuchMethodException e) {
                throw new LauncherException("Cannot find main method in `%s'!", entryPoint);
            }
            if (!Modifier.isStatic(mainMethod.getModifiers())) {
                throw new LauncherException("Cannot find static main method in `%s'!", entryPoint);
            }
            try {
                mainMethod.invoke(null, new Object[]{args});
            }
            catch (IllegalAccessException e) {
                throw new LauncherException("The main method of `%s' is not accessible!", entryPoint);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String locateEntryPoint(URL coverJar) throws LauncherException {
        String entryPoint = System.getProperty(ENTRYPOINT_PROPERTY);
        if (entryPoint != null) {
            return entryPoint;
        }
        try (InputStream coverJarInputStream = coverJar.openStream();
             JarInputStream jar = new JarInputStream(coverJarInputStream);){
            entryPoint = jar.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            if (entryPoint != null) {
                String string = entryPoint;
                return string;
            }
            throw new LauncherException("%s is not set, and %s does not specify a main class in its manifest!", ENTRYPOINT_PROPERTY, coverJar);
        }
        catch (IOException e) {
            throw new LauncherException("Reading the manifest of `%s' failed with a %s exception: %s", (Throwable)e, coverJar, e.getClass().getName(), e.getMessage());
        }
    }

    public static URL locateCoverJar() throws LauncherException {
        String coverURLProperty = System.getProperty(COVER_JAR_PATH_PROPERTY);
        if (coverURLProperty == null) {
            return Launcher.locateCoverJarUsingLauncherJarLocation(Launcher.class);
        }
        if (coverURLProperty.contains("file:") || coverURLProperty.contains("://")) {
            try {
                return new URL(coverURLProperty);
            }
            catch (MalformedURLException e) {
                throw new LauncherException("`%s' cannot be interpreted as a URL: %s", coverURLProperty, e.getMessage());
            }
        }
        try {
            return new File(coverURLProperty).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new LauncherException("`%s' cannot be interpreted as a path", coverURLProperty);
        }
    }

    public static URL locateCoverJarUsingLauncherJarLocation(Class<?> launcherClass) throws LauncherException {
        URL launcherURL = launcherClass.getProtectionDomain().getCodeSource().getLocation();
        try {
            Path parentPath = Paths.get(launcherURL.toURI()).getParent();
            assert (parentPath != null) : "Launcher jar cannot be the root directory";
            Path coverCliPath = parentPath.resolve("cover-cli.jar");
            if (!Files.exists(coverCliPath, new LinkOption[0])) {
                throw new LauncherException("Could not find cover in inferred location `%s'", coverCliPath);
            }
            return coverCliPath.toUri().toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException | FileSystemNotFoundException e) {
            throw new LauncherException("Error manipulating `%s' as a URL: %s", (Throwable)e, launcherURL, e.getMessage());
        }
    }
}

