/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.agent.defender;

import com.diffblue.cover.agent.defender.Capability;
import com.diffblue.cover.agent.defender.Policy;
import com.diffblue.cover.agent.defender.TrackerStore;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class Runtime {
    private static final EnumMap<Capability, Policy> policies = Runtime.nullPolicyPerCapability();
    private static final Map<String, List<Capability>> methodCapabilities = new LinkedHashMap<String, List<Capability>>();
    public static final String DEFENDER_PROPERTIES = "defender.properties";

    private static EnumMap<Capability, Policy> nullPolicyPerCapability() {
        EnumMap<Capability, Policy> policies = new EnumMap<Capability, Policy>(Capability.class);
        for (Capability capability : Capability.values()) {
            policies.put(capability, Policy.NULL);
        }
        return policies;
    }

    public static void makePermissive() {
        Runtime.setPolicy(Policy.NULL);
    }

    public static void setPolicy(Policy policy) {
        Runtime.setPolicy(policy, Capability.values());
    }

    public static void setPolicy(Policy policy, Capability ... capabilities) {
        for (Capability capability : capabilities) {
            policies.put(capability, policy);
        }
    }

    public static void check(String methodIdentifier, String callerMethod, @Nullable Object instance) {
        Runtime.check0(methodIdentifier, callerMethod, instance, new Object[0]);
    }

    public static void check(String dangerousMethod, String callerMethod, @Nullable Object instance, Object arg0) {
        Runtime.check0(dangerousMethod, callerMethod, instance, arg0);
    }

    public static void check(String dangerousMethod, String callerMethod, @Nullable Object instance, Object arg0, Object arg1) {
        Runtime.check0(dangerousMethod, callerMethod, instance, arg0, arg1);
    }

    public static void check(String dangerousMethod, String callerMethod, @Nullable Object instance, Object arg0, Object arg1, Object arg2) {
        Runtime.check0(dangerousMethod, callerMethod, instance, arg0, arg1, arg2);
    }

    public static void check(String dangerousMethod, String callerMethod, @Nullable Object instance, Object arg0, Object arg1, Object arg2, Object arg3) {
        Runtime.check0(dangerousMethod, callerMethod, instance, arg0, arg1, arg2, arg3);
    }

    public static void check(String dangerousMethod, String callerMethod, @Nullable Object instance, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        Runtime.check0(dangerousMethod, callerMethod, instance, arg0, arg1, arg2, arg3, arg4);
    }

    public static void check(String dangerousMethod, String callerMethod, @Nullable Object instance, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Runtime.check0(dangerousMethod, callerMethod, instance, arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public static void check(String dangerousMethod, String callerMethod, @Nullable Object instance, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        Runtime.check0(dangerousMethod, callerMethod, instance, arg0, arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public static void check(String dangerousMethod, String callerMethod, @Nullable Object instance, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        Runtime.check0(dangerousMethod, callerMethod, instance, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public static void check(String dangerousMethod, String callerMethod, @Nullable Object instance, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        Runtime.check0(dangerousMethod, callerMethod, instance, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    public static void check(String dangerousMethod, String callerMethod, @Nullable Object instance, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {
        Runtime.check0(dangerousMethod, callerMethod, instance, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    public static void check(String dangerousMethod, String callerMethod, @Nullable Object instance, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) {
        Runtime.check0(dangerousMethod, callerMethod, instance, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }

    private static void check0(String dangerousMethod, String callerMethod, @Nullable Object instance, Object ... params) {
        for (Capability capability : methodCapabilities.get(dangerousMethod)) {
            policies.get((Object)capability).check(capability, dangerousMethod, callerMethod, instance, params);
        }
    }

    public static void track(String dangerousMethod, String callerMethod, Object result) {
        for (Capability capability : methodCapabilities.get(dangerousMethod)) {
            policies.get((Object)capability).track(dangerousMethod, callerMethod, result);
        }
    }

    public static void isClean() {
        Runtime.apply(TrackerStore::isClean);
    }

    public static void clean() {
        Runtime.apply(TrackerStore::clean);
    }

    private static void apply(Consumer<TrackerStore<?>> consumer) {
        policies.values().stream().map(Policy::getTrackerStore).distinct().forEach(consumer);
    }

    public static Set<String> getDangerousMethods() {
        return methodCapabilities.keySet();
    }

    static {
        try (InputStream stream = Runtime.class.getResourceAsStream("/defender.properties");){
            Properties capabilities = new Properties();
            capabilities.load(stream);
            for (Map.Entry<Object, Object> entry : capabilities.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                methodCapabilities.put(key, Arrays.stream(value.split(",")).map(Capability::getCapability).sorted().collect(Collectors.toList()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

