/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.agent.coverage;

import com.diffblue.cover.agent.common.AgentLogLevel;
import com.diffblue.cover.agent.common.AgentLogging;
import com.diffblue.cover.agent.coverage.EdgeCoverage;
import com.diffblue.cover.agent.coverage.RecordingFilter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class EdgeCoverageRuntime {
    static final int CATCH_BLOCK_ID = -2;
    static final int BLOCK_EXIT_ID = -1;
    static final long ARTIFICIAL_BLOCK_ID_TRUE = -15L;
    static final long ARTIFICIAL_BLOCK_ID_FALSE = -16L;
    private static EdgeCoverage pathCounters = new EdgeCoverage();
    private static BufferedWriter log;
    private static String lastCaller;
    private static int[] previousLocation;
    private static RecordingFilter recordingFilter;
    private static int executionCounter;
    public static final Map<Integer, String> DEBUG_BLOCK_TO_HUMAN_READABLE;

    public static EdgeCoverage getPathCounters() {
        return pathCounters;
    }

    public static void reset() {
        pathCounters.clear();
        Arrays.fill(previousLocation, 0);
        if (AgentLogging.agentLogLevel == AgentLogLevel.TRACE && AgentLogging.shouldSaveCoverageDebugLogs) {
            try {
                if (log != null) {
                    try {
                        log.flush();
                        log.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Path logDirectory = AgentLogging.debugInformationDirectory.resolve("execs");
                Files.createDirectories(logDirectory, new FileAttribute[0]);
                Path logFile = logDirectory.resolve(String.format("%08d.txt", ++executionCounter));
                log = Files.newBufferedWriter(logFile.toFile().toPath(), Charset.defaultCharset(), new OpenOption[0]);
                lastCaller = "";
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to initialize a tracing log", e);
            }
        }
    }

    public static void startRecording(RecordingFilter filter) {
        recordingFilter = filter;
        Arrays.fill(previousLocation, 0);
        pathCounters.clear();
    }

    public static void stopRecording() {
        recordingFilter = null;
    }

    private static void onEdgeHit(int threadId255, long prevBlockId, long currentBlockId, Class<?> blockClass) {
        if (recordingFilter == null || !recordingFilter.matches(blockClass)) {
            return;
        }
        pathCounters.add(prevBlockId << 32 | currentBlockId & 0xFFFFFFFFL);
        EdgeCoverageRuntime.previousLocation[threadId255] = (int)currentBlockId;
        if (AgentLogging.agentLogLevel == AgentLogLevel.TRACE || EdgeCoverage.DEBUG_LOGGING) {
            EdgeCoverageRuntime.debug((int)currentBlockId, threadId255, (int)prevBlockId);
        }
    }

    public static synchronized void onBasicBlockHit(int currentBlockId, Class<?> blockClass) {
        int threadId255 = (int)Thread.currentThread().getId() & 0xFF;
        long prevBlockId = previousLocation[threadId255];
        EdgeCoverageRuntime.onEdgeHit(threadId255, prevBlockId, currentBlockId, blockClass);
    }

    public static synchronized void onCatchBlockEntry(int basicBlockId, int instructionNumber, Class<?> clazz) {
        int threadId255 = (int)Thread.currentThread().getId() & 0xFF;
        EdgeCoverageRuntime.onEdgeHit(threadId255, -2 - instructionNumber, basicBlockId, clazz);
        if (recordingFilter == null || !recordingFilter.matches(clazz)) {
            return;
        }
        EdgeCoverageRuntime.previousLocation[threadId255] = -2;
    }

    public static synchronized void onBasicBlockSpecialExit(Class<?> clazz) {
        EdgeCoverageRuntime.onBasicBlockHit(-1, clazz);
    }

    public static synchronized void onArtificialBranching(boolean positive, Class<?> blockClass) {
        if (recordingFilter == null || !recordingFilter.matches(blockClass)) {
            return;
        }
        pathCounters.add(positive ? -15L : -16L);
    }

    private static void debug(int currentBlockId, int threadId, int prevBlockId) {
        StackTraceElement[] stack = new Exception().getStackTrace();
        String caller = stack.length > 4 ? stack[4].toString() : stack[2].toString() + ", +0";
        DEBUG_BLOCK_TO_HUMAN_READABLE.put(currentBlockId, caller);
        StringBuilder sb = new StringBuilder();
        EdgeCoverageRuntime.printIntRightAdjusted(sb, threadId, 10);
        sb.append(' ');
        EdgeCoverageRuntime.printIntRightAdjusted(sb, currentBlockId, 10000);
        sb.append(' ');
        EdgeCoverageRuntime.printIntRightAdjusted(sb, prevBlockId, 10000);
        sb.append(' ');
        if (caller.equals(lastCaller)) {
            sb.append('^');
        } else {
            sb.append(caller);
            lastCaller = caller;
        }
        sb.append('\n');
        if (log != null) {
            try {
                log.write(sb.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void printIntRightAdjusted(StringBuilder sb, int i, int max) {
        while (i < max && max > 1) {
            sb.append(' ');
            max /= 10;
        }
        sb.append(i);
    }

    public static void ensureLoaded() {
    }

    static {
        previousLocation = new int[256];
        recordingFilter = null;
        executionCounter = 0;
        DEBUG_BLOCK_TO_HUMAN_READABLE = new LinkedHashMap<Integer, String>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, String> eldest) {
                return this.size() > 10000;
            }
        };
    }
}

