/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.agent.coverage;

import com.diffblue.cover.agent.common.AgentLogLevel;
import com.diffblue.cover.agent.common.AgentLogging;
import com.diffblue.cover.agent.coverage.EdgeCoverageRuntime;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class EdgeCoverage
implements Iterable<Long> {
    private Set<Long> edgeCoverage;
    public static final boolean DEBUG_LOGGING = System.getenv("DIFFBLUE_HUMAN_READABLE_BLOCKS") != null;

    public EdgeCoverage() {
        this.edgeCoverage = ConcurrentHashMap.newKeySet();
    }

    public EdgeCoverage(Set<Long> edgeCoverage) {
        this.edgeCoverage = edgeCoverage;
    }

    public boolean contains(long l) {
        return this.edgeCoverage.contains(l);
    }

    public boolean containsAll(EdgeCoverage ec) {
        return this.edgeCoverage.containsAll(ec.edgeCoverage);
    }

    public EdgeCoverage additionalCoverage(EdgeCoverage ec) {
        EdgeCoverage additional = new EdgeCoverage();
        for (Long coverage : ec.edgeCoverage) {
            if (this.edgeCoverage.contains(coverage)) continue;
            additional.add(coverage);
        }
        return additional;
    }

    public void clear() {
        this.edgeCoverage.clear();
    }

    public void add(long value) {
        this.edgeCoverage.add(value);
    }

    public boolean addAll(EdgeCoverage ec) {
        return this.edgeCoverage.addAll(ec.edgeCoverage);
    }

    public EdgeCoverage getImmutableCopy() {
        return new EdgeCoverage(Collections.unmodifiableSet(new LinkedHashSet<Long>(this.edgeCoverage)));
    }

    public int size() {
        return this.edgeCoverage.size();
    }

    public boolean isEmpty() {
        return this.edgeCoverage.isEmpty();
    }

    @Override
    public Iterator<Long> iterator() {
        return this.edgeCoverage.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("EdgeCoverage{");
        for (Long coverage : this.edgeCoverage) {
            if (coverage == -15L) {
                builder.append("artificial true; ");
                continue;
            }
            if (coverage == -16L) {
                builder.append("artificial false; ");
                continue;
            }
            long prevBlockId = coverage >> 32;
            long currentBlockId = (int)(coverage & 0xFFFFFFFFL);
            if (DEBUG_LOGGING || AgentLogging.agentLogLevel == AgentLogLevel.TRACE) {
                builder.append(EdgeCoverageRuntime.DEBUG_BLOCK_TO_HUMAN_READABLE.get((int)prevBlockId)).append("->").append(EdgeCoverageRuntime.DEBUG_BLOCK_TO_HUMAN_READABLE.get((int)currentBlockId)).append("/");
            }
            builder.append(EdgeCoverage.blockIdString(prevBlockId)).append(" --> ").append(EdgeCoverage.blockIdString(currentBlockId)).append("; ");
        }
        builder.append("}");
        return builder.toString();
    }

    private static String blockIdString(long blockId) {
        return blockId <= -2L ? "catch#" + (-2L - blockId) : (blockId == -1L ? "exit" : "block#" + blockId);
    }
}

