/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.agent.common;

import com.diffblue.cover.agent.common.AgentLogLevel;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Path;

public class AgentLogging {
    public static Path debugInformationDirectory;
    public static boolean shouldSaveInstrumentedClasses;
    public static boolean shouldSaveCoverageDebugLogs;
    public static boolean validateInstrumentedClassFile;
    public static AgentLogLevel agentLogLevel;
    private static PrintStream log;

    private AgentLogging() {
        throw new UnsupportedOperationException("AgentLogging cannot be instantiated.");
    }

    public static void debug(String format, Object ... arguments) {
        if (!AgentLogging.agentLogLevel.outputDebugLogging) {
            return;
        }
        AgentLogging.log(format, arguments);
    }

    public static void trace(String format, Object ... arguments) {
        if (!AgentLogging.agentLogLevel.outputTraceLogging) {
            return;
        }
        AgentLogging.log(format, arguments);
    }

    private static void log(String format, Object ... arguments) {
        long now = System.currentTimeMillis();
        log.printf("%tT.%tL agent: %s\n", now, now, String.format(format, arguments));
    }

    public static void start() {
        if (agentLogLevel != AgentLogLevel.NONE && debugInformationDirectory != null) {
            try {
                log = new PrintStream(debugInformationDirectory.resolve("agent.log").toFile(), Charset.defaultCharset().name());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        shouldSaveInstrumentedClasses = false;
        shouldSaveCoverageDebugLogs = false;
        validateInstrumentedClassFile = false;
        agentLogLevel = AgentLogLevel.NONE;
        log = System.err;
    }
}

