/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.agent;

import com.diffblue.cover.agent.UnboundedLoopException;
import com.diffblue.cover.agent.common.AgentLogging;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class ThreadStoppingAndExceptionHandlingRuntime {
    public static final String REACTOR_SCHEDULERS_CLASSNAME_PREFIX = "reactor.core.scheduler.";
    public static final String DISPOSE_METHOD_NAME = "dispose";
    private static volatile BooleanSupplier threadStoppingPredicate = () -> false;
    private static volatile BooleanSupplier threadRecordingPredicate = () -> false;
    public static boolean nullPointerCaught = false;
    private static int backEdgeCountLimit = Integer.MAX_VALUE;
    private static Predicate<String> backJumpStoppingClassFilter = className -> true;
    private static final int BITS_TO_HASH_IN_THREAD_ID = 8;
    private static final int THREAD_ID_HASH_MASK = 255;
    private static final AtomicIntegerArray backEdgeCounts = new AtomicIntegerArray(256);
    @Nullable
    private static volatile Consumer<ThreadDeath> loggingCallback;
    private static final List<ExecutorService> registeredExecutorServices;
    private static final List<Runnable> registeredDisposables;

    public static int updateBackEdgeCountLimit(int newValue) {
        int previous = backEdgeCountLimit;
        backEdgeCountLimit = newValue;
        return previous;
    }

    public static void clearBackEdgeCount() {
        for (int i = 0; i < backEdgeCounts.length(); ++i) {
            backEdgeCounts.set(i, 0);
        }
    }

    public static void setBackJumpStoppingClassFilter(Predicate<String> backJumpStoppingClassFilter) {
        ThreadStoppingAndExceptionHandlingRuntime.backJumpStoppingClassFilter = backJumpStoppingClassFilter;
    }

    public static BooleanSupplier getThreadStoppingPredicate() {
        return threadStoppingPredicate;
    }

    public static void setThreadStoppingPredicate(BooleanSupplier threadStoppingPredicate) {
        ThreadStoppingAndExceptionHandlingRuntime.threadStoppingPredicate = threadStoppingPredicate;
    }

    public static BooleanSupplier getThreadRecordingPredicate() {
        return threadRecordingPredicate;
    }

    public static void setThreadRecordingPredicate(BooleanSupplier threadRecordingPredicate) {
        ThreadStoppingAndExceptionHandlingRuntime.threadRecordingPredicate = threadRecordingPredicate;
    }

    private static void stopThreadIfNeccesary() {
        if (!threadStoppingPredicate.getAsBoolean()) {
            return;
        }
        ThreadStoppingAndExceptionHandlingRuntime.stopThread(null);
    }

    public static void stopThread(@Nullable Throwable cause) {
        Thread.currentThread().interrupt();
        ThreadDeath threadDeathError = new ThreadDeath();
        if (cause != null) {
            threadDeathError.initCause(cause);
        }
        ThreadStoppingAndExceptionHandlingRuntime.logThreadDeath(threadDeathError);
        if (Arrays.stream(threadDeathError.getStackTrace()).noneMatch(frame -> "<clinit>".equals(frame.getMethodName()))) {
            throw threadDeathError;
        }
    }

    private static void logThreadDeath(ThreadDeath threadDeathError) {
        Consumer<ThreadDeath> loggingCallback = ThreadStoppingAndExceptionHandlingRuntime.loggingCallback;
        if (loggingCallback != null) {
            loggingCallback.accept(threadDeathError);
        }
    }

    public static void onBackJump() {
        if (!Thread.currentThread().isInterrupted()) {
            return;
        }
        ThreadStoppingAndExceptionHandlingRuntime.stopThreadIfNeccesary();
    }

    public static void onCodeUnderTestBackJump() {
        if (!Thread.currentThread().isInterrupted()) {
            int backEdgeCount = backEdgeCounts.incrementAndGet((int)(Thread.currentThread().getId() & 0xFFL));
            if (backEdgeCount > backEdgeCountLimit) {
                backEdgeCounts.set((int)(Thread.currentThread().getId() & 0xFFL), 0);
                StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[2];
                String frame = stackTraceElement.toString();
                if (backJumpStoppingClassFilter.test(frame)) {
                    ThreadStoppingAndExceptionHandlingRuntime.stopThread(new UnboundedLoopException(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber()));
                }
            }
            return;
        }
        ThreadStoppingAndExceptionHandlingRuntime.stopThreadIfNeccesary();
    }

    public static void onCatchBlock(Throwable exception) {
        if (exception.getClass().getName().equals("com.diffblue.cover.defender.ForbiddenByPolicyError") && exception instanceof Error) {
            throw (Error)exception;
        }
        if (exception instanceof InterruptedException || exception instanceof ThreadDeath || Thread.currentThread().isInterrupted()) {
            ThreadStoppingAndExceptionHandlingRuntime.stopThreadIfNeccesary();
        }
        if (exception instanceof NullPointerException) {
            nullPointerCaught = true;
        }
    }

    public static List<ExecutorService> getRegisteredExecutorServices() {
        return Collections.unmodifiableList(registeredExecutorServices);
    }

    public static List<Runnable> getRegisteredDisposables() {
        return Collections.unmodifiableList(registeredDisposables);
    }

    public static void clearRegisteredExecutorServices() {
        registeredExecutorServices.clear();
    }

    public static void clearRegisteredDisposables() {
        registeredDisposables.clear();
    }

    public static void onExecutorServiceCreation(ExecutorService service) {
        Thread currentThread;
        if (threadRecordingPredicate.getAsBoolean() && !ThreadStoppingAndExceptionHandlingRuntime.isManagedByReactorSchedulers(currentThread = Thread.currentThread()) && !ThreadStoppingAndExceptionHandlingRuntime.isNettyExecutor(service)) {
            registeredExecutorServices.add(service);
        }
    }

    public static void onDisposableCreation(Object disposable) {
        if (threadRecordingPredicate.getAsBoolean()) {
            try {
                Method disposeMethod = disposable.getClass().getDeclaredMethod(DISPOSE_METHOD_NAME, new Class[0]);
                disposeMethod.setAccessible(true);
                Runnable dispose = () -> {
                    try {
                        disposeMethod.invoke(disposable, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                };
                registeredDisposables.add(dispose);
            }
            catch (NoSuchMethodException e) {
                AgentLogging.debug("Callback called on method that does not implement Disposable: %s. It will not be recorded.", e.getMessage());
            }
        }
    }

    private static boolean isManagedByReactorSchedulers(Thread currentThread) {
        return Arrays.stream(currentThread.getStackTrace()).anyMatch(stackTraceElement -> stackTraceElement.getClassName().startsWith(REACTOR_SCHEDULERS_CLASSNAME_PREFIX));
    }

    private static boolean isNettyExecutor(ExecutorService service) {
        return service.getClass().getName().startsWith("io.netty");
    }

    public static void setLoggingCallback(@Nullable Consumer<ThreadDeath> loggingCallback) {
        ThreadStoppingAndExceptionHandlingRuntime.loggingCallback = loggingCallback;
    }

    static {
        registeredExecutorServices = new ArrayList<ExecutorService>();
        registeredDisposables = new ArrayList<Runnable>();
    }
}

