/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.agent;

import java.io.Closeable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;

public class FileLeaksRuntime {
    private static Set<Closeable> OPEN_FILES = null;
    private static BooleanSupplier recordingFilter = () -> false;
    private static List<String> jdkFilePackagePrefixes = Arrays.asList("java.io.", "java.nio.channels.", "java.nio.file.", "java.util.zip.", "sun.nio.ch.");
    private static List<String> jdkOtherPackagePrefixes = Arrays.asList("com.oracle.", "com.sun.", "java.", "javax.", "jdk.", "org.ietf.", "org.jcp.", "org.omg.", "org.w3c.", "org.xml.", "sun.");

    public static void ensureLoaded() {
    }

    private static boolean hasPrefixIn(String text, List<String> prefixes) {
        for (String prefix : prefixes) {
            if (!text.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static synchronized void setRecordingFilter(BooleanSupplier filter) {
        recordingFilter = filter != null ? filter : () -> false;
    }

    public static synchronized void startRecording() {
        if (OPEN_FILES != null) {
            return;
        }
        OPEN_FILES = new LinkedHashSet<Closeable>();
    }

    public static synchronized Set<Closeable> stopRecording() {
        if (OPEN_FILES == null) {
            throw new IllegalStateException("Recording was not started.");
        }
        Set<Closeable> result = OPEN_FILES;
        OPEN_FILES = null;
        return result;
    }

    public static synchronized void onFileOpen(Closeable c) {
        if (OPEN_FILES != null && recordingFilter.getAsBoolean()) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            for (int i = 2; i < stack.length; ++i) {
                String className = stack[i].getClassName();
                boolean hasJdkFilePrefix = FileLeaksRuntime.hasPrefixIn(className, jdkFilePackagePrefixes);
                if (FileLeaksRuntime.hasPrefixIn(className, jdkOtherPackagePrefixes) && !hasJdkFilePrefix) {
                    return;
                }
                if (!hasJdkFilePrefix) break;
            }
            OPEN_FILES.add(c);
        }
    }

    public static synchronized void onFileClose(Closeable c) {
        if (OPEN_FILES != null) {
            OPEN_FILES.remove(c);
        }
    }
}

