/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.agent;

import com.diffblue.cover.agent.common.AgentLogLevel;
import com.diffblue.cover.agent.common.AgentLogging;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.jar.JarFile;

public class Agent {
    private static final String AGENT_JAR_PROPERTY = "cover.launcher.jar.path";
    private static Instrumentation instrumentation;

    public static void premain(String commandline, Instrumentation instrumentation) {
        Agent.instrumentation = instrumentation;
        Agent.installAgentJarInBootClasspath();
        String[] arguments = commandline == null ? new String[]{} : commandline.split(",");
        Agent.parseAgentOptions(arguments);
    }

    public static boolean isPresent() {
        return instrumentation != null;
    }

    private static void installAgentJarInBootClasspath() {
        try {
            File agentJarPath = Agent.findAgentJar();
            JarFile agentJar = new JarFile(agentJarPath);
            instrumentation.appendToBootstrapClassLoaderSearch(agentJar);
        }
        catch (FileNotFoundException e) {
            System.err.printf("Could not find agent jar: %s\n", e.getMessage());
            System.exit(1);
        }
        catch (IOException | URISyntaxException e) {
            System.err.println("Could not add agent jar to the boot classpath.");
            System.err.printf("Exception was %s (%s)\n", e.getClass().getSimpleName(), e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static File findAgentJar() throws URISyntaxException, IOException {
        URI agentClassUri = Agent.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        Path agentClassPath = Paths.get(agentClassUri);
        if (Files.isRegularFile(agentClassPath, new LinkOption[0])) {
            return agentClassPath.toFile();
        }
        Path agentDirectory = agentClassPath.getParent();
        if (agentDirectory == null) {
            throw new FileNotFoundException(String.format("Agent jar path %s cannot be the root directory", agentClassPath));
        }
        Path agentPathPropertyFile = agentDirectory.resolve("agent.properties");
        if (!Files.isRegularFile(agentPathPropertyFile, new LinkOption[0])) {
            throw new FileNotFoundException(String.format("Couldn't find agent jar in %s", agentClassPath));
        }
        Properties props = new Properties();
        try (FileInputStream agentProperties = new FileInputStream(agentPathPropertyFile.toFile());){
            props.load(agentProperties);
        }
        String namedAgentJar = props.getProperty(AGENT_JAR_PROPERTY);
        if (namedAgentJar != null) {
            return new File(namedAgentJar);
        }
        throw new FileNotFoundException(String.format("Couldn't find agent jar specification in %s", agentPathPropertyFile));
    }

    public static void registerAgent(ClassFileTransformer classFileTransformer, boolean supportsReTransformation) {
        if (instrumentation == null) {
            return;
        }
        instrumentation.addTransformer(classFileTransformer, supportsReTransformation);
    }

    public static void parseAgentOptions(String[] arguments) {
        block16: for (String rawArgument : arguments) {
            String[] argumentAndParameter = rawArgument.split("=", 2);
            String argument = argumentAndParameter[0];
            String parameter = argumentAndParameter.length > 1 ? argumentAndParameter[1] : null;
            switch (argument) {
                case "debug": {
                    AgentLogging.agentLogLevel = AgentLogging.agentLogLevel.maybeRaiseTo(AgentLogLevel.DEBUG);
                    continue block16;
                }
                case "trace": {
                    AgentLogging.agentLogLevel = AgentLogging.agentLogLevel.maybeRaiseTo(AgentLogLevel.TRACE);
                    continue block16;
                }
                case "validate": {
                    AgentLogging.validateInstrumentedClassFile = true;
                    continue block16;
                }
                case "debug-output-dir": {
                    if (parameter == null) {
                        System.err.println("The debug-output-dir option requires an argument!");
                        System.exit(1);
                    }
                    AgentLogging.debugInformationDirectory = Paths.get(parameter, new String[0]);
                    continue block16;
                }
                case "save-instrumented": {
                    AgentLogging.shouldSaveInstrumentedClasses = true;
                    continue block16;
                }
                case "save-coverage-logs": {
                    AgentLogging.shouldSaveCoverageDebugLogs = true;
                    continue block16;
                }
                default: {
                    System.err.printf("Could not parse parameter %s\n", rawArgument);
                    System.exit(1);
                }
            }
        }
        if ((AgentLogging.shouldSaveCoverageDebugLogs || AgentLogging.shouldSaveInstrumentedClasses) && AgentLogging.debugInformationDirectory == null) {
            System.err.println("When using save-instrumented or save-coverage-logs, a debug-output-dir must be set!");
            System.exit(1);
        }
        AgentLogging.start();
    }

    public static boolean isReTransformationClassesSupported() {
        return instrumentation != null && instrumentation.isRetransformClassesSupported();
    }

    public static void retransformClasses(Class<?> ... classes) throws UnmodifiableClassException {
        instrumentation.retransformClasses(classes);
    }

    public static void injectInstrumentation(Consumer<Instrumentation> instrumentationConsumer) {
        if (instrumentation != null) {
            instrumentationConsumer.accept(instrumentation);
        }
    }
}

