/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.serialization;

import com.diffblue.cover.buildsystem.model.Message;
import com.diffblue.cover.buildsystem.serialization.MessageTypeResolverBuilder;
import com.diffblue.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.diffblue.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.diffblue.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.diffblue.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.diffblue.shaded.com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.diffblue.shaded.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public class Utils {
    static ObjectMapper createObjectMapper(@Nullable Class<?> target, @Nullable Class<?> mixinSource) {
        ObjectMapper objectMapper = new ObjectMapper();
        BasicPolymorphicTypeValidator ptv = BasicPolymorphicTypeValidator.builder().allowIfSubType(Message.class).build();
        objectMapper.setDefaultTyping(new MessageTypeResolverBuilder(ptv));
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.registerModule(new Jdk8Module());
        if (target != null && mixinSource != null) {
            objectMapper.addMixIn(target, mixinSource);
        }
        return objectMapper;
    }

    public static ObjectMapper createObjectMapper() {
        return Utils.createObjectMapper(null, null);
    }

    public static void writeMessage(Message message, @Nullable BiConsumer<String, Exception> onException, Class<?> target, Class<?> mixinSource) {
        ObjectMapper mapper = Utils.createObjectMapper(target, mixinSource);
        Utils.writeMessage(message, onException, mapper);
    }

    public static void writeMessage(Message message, @Nullable BiConsumer<String, Exception> onException) {
        ObjectMapper mapper = Utils.createObjectMapper();
        Utils.writeMessage(message, onException, mapper);
    }

    private static void writeMessage(Message message, @Nullable BiConsumer<String, Exception> onException, ObjectMapper mapper) {
        block2: {
            try {
                System.out.println("[DIFFBLUE]" + mapper.writeValueAsString(message));
            }
            catch (JsonProcessingException jsonProcessingException) {
                if (onException == null) break block2;
                onException.accept(String.format("Message not processed %s", message), jsonProcessingException);
            }
        }
    }

    @Nullable
    public static Message readMessage(String line, @Nullable BiConsumer<String, Exception> onException) {
        ObjectMapper mapper = Utils.createObjectMapper();
        try {
            int index = line.indexOf("[DIFFBLUE]");
            if (index == -1) {
                return null;
            }
            String message = line.substring(index + "[DIFFBLUE]".length());
            return mapper.readValue(message, Message.class);
        }
        catch (JsonProcessingException e) {
            if (onException != null) {
                onException.accept(String.format("Message not processed %s", line), e);
            }
            return null;
        }
    }
}

