/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.model;

import com.diffblue.cover.buildsystem.model.ProjectModule;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.annotation.Nullable;

public class ProjectModulePrinter {
    private final ProjectModule projectModule;
    private final boolean isGradleProject;

    public ProjectModulePrinter(ProjectModule projectModule, boolean isGradleProject) {
        this.projectModule = projectModule;
        this.isGradleProject = isGradleProject;
    }

    public String print(String indent, boolean detailed) {
        StringBuilder sb = new StringBuilder();
        if (detailed) {
            this.appendIfValuePresent(sb, indent, "ProjectModule: ", this.projectModule.getFullModuleName());
            this.appendIfValuePresent(sb, indent, "Location: ", this.projectModule.getLocation());
            String parentModuleName = this.projectModule.getParentModuleName();
            if (this.isGradleProject && (parentModuleName == null || parentModuleName.isEmpty())) {
                parentModuleName = this.inferGradleParentModule(this.projectModule);
            }
            this.appendIfValuePresent(sb, indent, "ParentModuleName: ", parentModuleName);
        } else {
            this.appendIfValuePresent(sb, indent, "Module: ", this.projectModule.getFullModuleName());
        }
        if (this.projectModule.getSubModules() != null && !this.projectModule.getSubModules().isEmpty()) {
            this.printSubModules(sb, this.projectModule.getSubModules(), indent + "  ", detailed);
        }
        return sb.toString();
    }

    private String inferGradleParentModule(ProjectModule module) {
        if (module.getLocation() == null) {
            return null;
        }
        try {
            Path rootPath;
            Path modulePath = Paths.get(module.getLocation().toURI());
            Path parentPath = modulePath.getParent();
            if (parentPath != null && parentPath.getParent() != null && ((rootPath = parentPath.getParent()).resolve("settings.gradle").toFile().exists() || rootPath.resolve("build.gradle").toFile().exists())) {
                return rootPath.getFileName().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private <T> void appendIfValuePresent(StringBuilder builder, String indent, String key, @Nullable T value) {
        if (value == null) {
            return;
        }
        builder.append(indent).append(key).append(value).append("\n");
    }

    private void printSubModules(StringBuilder sb, @Nullable List<? extends ProjectModule> subModules, String indent, boolean detailed) {
        if (subModules != null) {
            for (ProjectModule projectModule : subModules) {
                ProjectModulePrinter subModulePrinter = new ProjectModulePrinter(projectModule, this.isGradleProject);
                sb.append(subModulePrinter.print(indent, detailed));
            }
        } else {
            sb.append(indent).append("None\n");
        }
    }
}

