/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.gradle.plugin;

import com.diffblue.cover.buildsystem.gradle.plugin.ProjectModuleModelBuilder;
import com.diffblue.cover.buildsystem.model.DefaultEventMessage;
import com.diffblue.cover.buildsystem.model.DefaultProjectModuleMessage;
import com.diffblue.cover.buildsystem.model.EventMessage;
import com.diffblue.cover.buildsystem.model.Message;
import com.diffblue.cover.buildsystem.model.ProjectModule;
import com.diffblue.cover.buildsystem.model.State;
import com.diffblue.cover.buildsystem.serialization.Utils;
import org.gradle.BuildAdapter;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskState;

public class GradleSpy
extends BuildAdapter
implements TaskExecutionListener {
    private static final Logger logger = Logging.getLogger(GradleSpy.class);
    private static GradleSpy instance = null;

    public static GradleSpy getInstance() {
        if (instance == null) {
            instance = new GradleSpy();
        }
        return instance;
    }

    private GradleSpy() {
        logger.lifecycle("Started Diffblue Gradle Event Listener");
    }

    public void beforeExecute(Task task) {
        GradleSpy.writeMessage(new DefaultEventMessage(GradleSpy.getIdentifier(task.getProject()), task.getName(), null, State.STARTED));
    }

    public void afterExecute(Task task, TaskState taskState) {
        State EventMessageState = State.SUCCESS;
        if (taskState.getSkipped()) {
            EventMessageState = State.SKIPPED;
        } else if (taskState.getFailure() != null) {
            EventMessageState = State.ERROR;
        }
        GradleSpy.writeMessage(new DefaultEventMessage(GradleSpy.getIdentifier(task.getProject()), task.getName(), taskState.getFailure() == null ? null : taskState.getFailure().getCause(), EventMessageState));
    }

    public void projectsEvaluated(Gradle gradle) {
        Project project = gradle.getRootProject();
        GradleSpy.writeMessage(new DefaultProjectModuleMessage((ProjectModule)new ProjectModuleModelBuilder().buildAll(ProjectModuleModelBuilder.MODEL_NAME, project)));
    }

    private static void writeMessage(Message message) {
        String messageType = "unknown";
        if (message instanceof EventMessage) {
            messageType = "event";
        } else if (message instanceof DefaultProjectModuleMessage) {
            messageType = "project module";
        }
        logger.info("Writing Diffblue message ({} type)", (Object)messageType);
        Utils.writeMessage(message, (arg_0, arg_1) -> ((Logger)logger).warn(arg_0, arg_1));
    }

    private static String getIdentifier(Project project) {
        String moduleName = project.getPath();
        if (moduleName.startsWith(":")) {
            moduleName = moduleName.substring(1);
        }
        if (moduleName.isEmpty()) {
            moduleName = project.getName();
        }
        return moduleName;
    }
}

