/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.gradle.plugin;

import com.diffblue.cover.buildsystem.model.Download;
import java.io.File;
import java.io.Serializable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class DownloadManager
implements ToolingModelBuilder {
    public boolean canBuild(String modelName) {
        return Download.class.getName().equals(modelName);
    }

    public Object buildAll(String modelName, Project project) {
        assert (this.canBuild(modelName)) : "Unsupported model name: " + modelName;
        Configuration configuration = project.getConfigurations().getByName("__diffblue__Download");
        File singleFile = configuration.getSingleFile();
        return new ImmutableDownload(singleFile);
    }

    public void configure(Project project) {
        Object groupId = project.findProperty("__diffblue__Download__groupId");
        Object artifactId = project.findProperty("__diffblue__Download__artifactId");
        Object version = project.findProperty("__diffblue__Download__version");
        if (groupId == null || artifactId == null || version == null) {
            return;
        }
        Configuration configuration = (Configuration)project.getConfigurations().register("__diffblue__Download").get();
        configuration.getResolutionStrategy().deactivateDependencyLocking();
        configuration.setTransitive(false);
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add("__diffblue__Download", (Object)String.format("%s:%s:%s", groupId, artifactId, version));
        ((Task)project.getTasks().register("__diffblue__Download").get()).dependsOn(new Object[]{configuration});
    }

    public static class ImmutableDownload
    implements Download,
    Serializable {
        private final File file;

        ImmutableDownload(File file) {
            this.file = file;
        }

        @Override
        public File getFile() {
            return this.file;
        }
    }
}

