/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.maven;

import com.diffblue.cover.buildsystem.maven.internal.ProjectModuleBuilderUtils;
import com.diffblue.cover.buildsystem.model.DefaultPlugin;
import com.diffblue.cover.buildsystem.model.DefaultProjectModuleBuilder;
import com.diffblue.cover.buildsystem.model.ProjectModule;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.Artifact;

public class ProjectModuleBuilder {
    private static final String JACOCO_XML_FILE_NAME = "jacoco.xml";
    private static final Path DEFAULT_JACOCO_REPORT_PATH = Paths.get("site/jacoco", new String[0]);
    private static final Path SUREFIRE_DEFAULT_REPORTS_DIRECTORY = Paths.get("surefire-reports", new String[0]);

    static ProjectModule build(MavenSession session, EventSpy.Context context, Map<Artifact, DependencyResolutionResult> resolvedDependencies) {
        Map modules = session.getAllProjects().stream().map(submodule -> ProjectModuleBuilder.realBuild(submodule, context, ProjectModuleBuilder.getFor(submodule, resolvedDependencies))).collect(Collectors.toMap(DefaultProjectModuleBuilder::getName, Function.identity()));
        Map<Path, DefaultProjectModuleBuilder> modulesByLocation = modules.values().stream().collect(Collectors.toMap(module -> module.getLocation().toPath(), Function.identity()));
        Path rootLocation = session.getTopLevelProject().getBasedir().toPath();
        DefaultProjectModuleBuilder rootBuilder = (DefaultProjectModuleBuilder)modulesByLocation.get(rootLocation);
        assert (rootBuilder != null) : String.format("Expected the root project to be located at: %s", rootLocation);
        ProjectModuleBuilder.treeify(modulesByLocation, rootBuilder, rootLocation);
        return rootBuilder.build();
    }

    @Nullable
    private static DependencyResolutionResult getFor(MavenProject project, Map<Artifact, DependencyResolutionResult> resolvedDependencies) {
        org.apache.maven.artifact.Artifact projectArtifact = project.getArtifact();
        Optional<Artifact> optionalArtifact = resolvedDependencies.values().stream().map(resolved -> resolved.getDependencyGraph().getArtifact()).filter(a -> a.getArtifactId().equals(projectArtifact.getArtifactId())).filter(a -> a.getGroupId().equals(projectArtifact.getGroupId())).filter(a -> a.getVersion().equals(projectArtifact.getVersion())).findFirst();
        return optionalArtifact.map(resolvedDependencies::get).orElse(null);
    }

    private static void treeify(Map<Path, DefaultProjectModuleBuilder> modulesByLocation, DefaultProjectModuleBuilder builder, Path location) {
        List<DefaultProjectModuleBuilder> modules = builder.getSubModules();
        for (int i = 0; i < modules.size(); ++i) {
            Path moduleLocation = location.resolve(modules.get(i).getName()).normalize();
            DefaultProjectModuleBuilder moduleBuilder = modulesByLocation.get(moduleLocation);
            assert (moduleBuilder != null) : "Expected to find parsed module representing " + moduleLocation;
            modules.set(i, moduleBuilder);
            ProjectModuleBuilder.treeify(modulesByLocation, moduleBuilder, moduleLocation);
        }
    }

    private static DefaultProjectModuleBuilder realBuild(MavenProject project, EventSpy.Context context, @Nullable DependencyResolutionResult resolvedDependencies) {
        DefaultProjectModuleBuilder projectModuleBuilder = new DefaultProjectModuleBuilder();
        Properties projectProperties = project.getProperties();
        projectModuleBuilder.setFullName(ProjectModuleBuilderUtils.computeName(project)).setParent(ProjectModuleBuilderUtils.computeName(project.getParent())).setLocation(project.getBasedir()).setEncoding(projectProperties.getProperty("project.build.sourceEncoding"));
        ProjectModuleBuilder.describeContext(projectModuleBuilder, context);
        ProjectModuleBuilder.describeTestClasspath(projectModuleBuilder, project, resolvedDependencies);
        ProjectModuleBuilder.describeBuild(projectModuleBuilder, project);
        ProjectModuleBuilder.describePlugins(projectModuleBuilder, project);
        ProjectModuleBuilder.describeJavaComplianceLevel(projectModuleBuilder, project);
        projectModuleBuilder.setSubModules(project.getModules().stream().map(module -> new DefaultProjectModuleBuilder().setFullName((String)module)).collect(Collectors.toList()));
        return projectModuleBuilder;
    }

    private static void describeTestClasspath(DefaultProjectModuleBuilder projectModuleBuilder, MavenProject project, @Nullable DependencyResolutionResult resolvedDependencies) {
        ArrayList<File> testClasspath = new ArrayList<File>();
        testClasspath.add(new File(project.getBuild().getOutputDirectory()));
        testClasspath.addAll(ProjectModuleBuilderUtils.computeDependencyList(resolvedDependencies));
        testClasspath.removeIf(Objects::isNull);
        projectModuleBuilder.setRuntimeClasspath(testClasspath);
    }

    private static void describeContext(DefaultProjectModuleBuilder projectModuleBuilder, EventSpy.Context context) {
        projectModuleBuilder.setBuildSystemName("maven");
        Map data = context.getData();
        if (data == null) {
            return;
        }
        Object versionProperties = data.get("versionProperties");
        if (versionProperties instanceof Properties) {
            projectModuleBuilder.setBuildSystemVersion(((Properties)versionProperties).getProperty("version", null));
        }
    }

    private static void describeBuild(DefaultProjectModuleBuilder projectModuleBuilder, MavenProject project) {
        Build build = project.getBuild();
        List<String> jacocoOutputDirectory = ProjectModuleBuilder.findPluginConfigValue(build, "jacoco-maven-plugin", "outputDirectory");
        List<String> jacocoPaths = jacocoOutputDirectory != null && !jacocoOutputDirectory.isEmpty() ? jacocoOutputDirectory.stream().map(x$0 -> Paths.get(x$0, new String[0])).map(p -> {
            if (p.isAbsolute()) {
                return p;
            }
            return project.getBasedir().toPath().resolve((Path)p);
        }).map(p -> {
            if (p.getFileName().endsWith(JACOCO_XML_FILE_NAME)) {
                return p;
            }
            return p.resolve(JACOCO_XML_FILE_NAME);
        }).map(Path::toString).collect(Collectors.toList()) : Collections.singletonList(Paths.get(build.getDirectory(), new String[0]).resolve(DEFAULT_JACOCO_REPORT_PATH).resolve(JACOCO_XML_FILE_NAME).toString());
        projectModuleBuilder.setJacocoReportDirectories(jacocoPaths);
        Optional<String> jacocoFormats = ProjectModuleBuilder.findFirstPluginConfigValue(build, "jacoco-maven-plugin", "formats");
        List<String> configuredFormats = jacocoFormats == null || !jacocoFormats.isPresent() ? Collections.singletonList("xml") : Arrays.asList(jacocoFormats.get().split(","));
        projectModuleBuilder.setJacocoFormats(configuredFormats);
        Optional<String> isJacocoSkipped = ProjectModuleBuilder.findProjectProperty("jacoco.skip", project.getProperties());
        if (isJacocoSkipped != null && isJacocoSkipped.isPresent()) {
            projectModuleBuilder.setIsJacocoSkipped(true);
        } else {
            projectModuleBuilder.setIsJacocoSkipped(false);
        }
        LinkedHashSet<String> jacocoDestFiles = new LinkedHashSet<String>();
        ProjectModuleBuilder.findProjectProperty("destFile", project.getProperties()).ifPresent(jacocoDestFiles::add);
        List<String> pluginConfigValue = ProjectModuleBuilder.findPluginConfigValue(build, "jacoco-maven-plugin", "destFile");
        if (pluginConfigValue != null) {
            jacocoDestFiles.addAll(pluginConfigValue);
        }
        jacocoDestFiles.add(project.getBasedir().toPath().resolve(project.getBuild().getDirectory()).resolve("jacoco.exec").toString());
        projectModuleBuilder.setJacocoDestFile(new ArrayList<String>(jacocoDestFiles));
        Optional<String> junitOutputDirectory = ProjectModuleBuilder.findFirstPluginConfigValue(build, "maven-surefire-plugin", "reportsDirectory");
        if (junitOutputDirectory != null && junitOutputDirectory.isPresent()) {
            projectModuleBuilder.setJunitReportDirectories(junitOutputDirectory.map(d -> {
                if (Paths.get(d, new String[0]).isAbsolute()) {
                    return d;
                }
                return project.getBasedir().toPath().resolve((String)d).toString();
            }).map(Collections::singletonList).orElse(null));
        } else {
            Path surefireReportsDirectory = project.getBasedir().toPath().resolve(project.getBuild().getDirectory()).resolve(SUREFIRE_DEFAULT_REPORTS_DIRECTORY);
            projectModuleBuilder.setJunitReportDirectories(Collections.singletonList(surefireReportsDirectory.toString()));
        }
        projectModuleBuilder.setProductionSourceDirectories(Collections.singletonList(new File(build.getSourceDirectory())));
        projectModuleBuilder.setTestSourceDirectories(Collections.singletonList(new File(build.getTestSourceDirectory())));
        if (build.getOutputDirectory() != null) {
            projectModuleBuilder.setProductionClasses(new File(build.getOutputDirectory()));
        } else {
            projectModuleBuilder.setProductionClasses(project.getBasedir().toPath().resolve("target/classes").toFile());
        }
        if (build.getTestOutputDirectory() != null) {
            projectModuleBuilder.setTestClasses(new File(build.getTestOutputDirectory()));
        } else {
            projectModuleBuilder.setProductionClasses(project.getBasedir().toPath().resolve("target/test-classes").toFile());
        }
        projectModuleBuilder.setBuildDirectory(project.getBasedir().toPath().resolve("target").toFile());
    }

    private static void describeJavaComplianceLevel(DefaultProjectModuleBuilder projectModuleBuilder, MavenProject project) {
        Build build = project.getBuild();
        Properties projectProperties = project.getProperties();
        LinkedList<Optional<String>> complianceLevels = new LinkedList<Optional<String>>();
        complianceLevels.add(ProjectModuleBuilder.findFirstPluginConfigValue(build, "maven-compiler-plugin", "testRelease"));
        complianceLevels.add(ProjectModuleBuilder.findProjectProperty("maven.compiler.testRelease", projectProperties));
        complianceLevels.add(ProjectModuleBuilder.findFirstPluginConfigValue(build, "maven-compiler-plugin", "testTarget"));
        complianceLevels.add(ProjectModuleBuilder.findProjectProperty("maven.compiler.testTarget", projectProperties));
        complianceLevels.add(ProjectModuleBuilder.findFirstPluginConfigValue(build, "maven-compiler-plugin", "testSource"));
        complianceLevels.add(ProjectModuleBuilder.findProjectProperty("maven.compiler.testSource", projectProperties));
        complianceLevels.add(ProjectModuleBuilder.findFirstPluginConfigValue(build, "maven-compiler-plugin", "release"));
        complianceLevels.add(ProjectModuleBuilder.findProjectProperty("maven.compiler.release", projectProperties));
        complianceLevels.add(ProjectModuleBuilder.findFirstPluginConfigValue(build, "maven-compiler-plugin", "target"));
        complianceLevels.add(ProjectModuleBuilder.findProjectProperty("maven.compiler.target", projectProperties));
        complianceLevels.add(ProjectModuleBuilder.findFirstPluginConfigValue(build, "maven-compiler-plugin", "source"));
        complianceLevels.add(ProjectModuleBuilder.findProjectProperty("maven.compiler.source", projectProperties));
        String complianceLevel = complianceLevels.stream().filter(Objects::nonNull).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
        projectModuleBuilder.setJavaComplianceLevel(complianceLevel);
    }

    private static Optional<String> findProjectProperty(String key, Properties projectProperties) {
        return Optional.ofNullable(projectProperties.getProperty(key));
    }

    @Nullable
    private static Optional<String> findFirstPluginConfigValue(Build build, String pluginNameContains, String configurationKey) {
        List<String> pluginConfigValue = ProjectModuleBuilder.findPluginConfigValue(build, pluginNameContains, configurationKey);
        if (pluginConfigValue == null) {
            return null;
        }
        return pluginConfigValue.stream().findFirst();
    }

    @Nullable
    private static List<String> findPluginConfigValue(Build build, String pluginNameContains, String configurationKey) {
        List plugins = Stream.concat(build.getPluginsAsMap().entrySet().stream(), build.getPluginManagement().getPluginsAsMap().entrySet().stream()).filter(entry -> ((String)entry.getKey()).contains(pluginNameContains)).map(Map.Entry::getValue).filter(Objects::nonNull).collect(Collectors.toList());
        if (plugins.isEmpty()) {
            return null;
        }
        return Stream.concat(plugins.stream().map(Plugin::getExecutions).flatMap(Collection::stream).map(ConfigurationContainer::getConfiguration), plugins.stream().map(ConfigurationContainer::getConfiguration)).filter(Objects::nonNull).filter(entry -> entry instanceof Xpp3Dom).map(entry -> (Xpp3Dom)entry).flatMap(dom -> Arrays.stream(dom.getChildren())).filter(dom -> dom.getName().equals(configurationKey)).map(Xpp3Dom::getValue).collect(Collectors.toList());
    }

    private static void describePlugins(DefaultProjectModuleBuilder projectModuleBuilder, MavenProject project) {
        projectModuleBuilder.setActivePlugins(project.getModel().getBuild().getPlugins().stream().map(mavenPlugin -> new DefaultPlugin(mavenPlugin.getGroupId(), mavenPlugin.getArtifactId(), mavenPlugin.getVersion(), null)).collect(Collectors.toList()));
    }
}

