/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.maven;

import com.diffblue.cover.buildsystem.maven.LifecycleExecutionExceptionMixin;
import com.diffblue.cover.buildsystem.maven.ProjectModuleBuilder;
import com.diffblue.cover.buildsystem.maven.internal.ProjectModuleBuilderUtils;
import com.diffblue.cover.buildsystem.model.DefaultEventMessage;
import com.diffblue.cover.buildsystem.model.DefaultProjectModuleMessage;
import com.diffblue.cover.buildsystem.model.ProjectInfoMessage;
import com.diffblue.cover.buildsystem.model.State;
import com.diffblue.cover.buildsystem.serialization.Utils;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;

@Named
@Singleton
public class MavenListener
extends AbstractEventSpy {
    private final Set<MavenProject> allProjects = new LinkedHashSet<MavenProject>();
    private EventSpy.Context context;
    private final Map<Artifact, DependencyResolutionResult> resolvedDependencies = new LinkedHashMap<Artifact, DependencyResolutionResult>();

    public void init(EventSpy.Context context) throws Exception {
        super.init(context);
        this.context = context;
    }

    public void onEvent(@Nonnull Object event) {
        if (event instanceof ExecutionEvent) {
            ExecutionEvent executionEvent = (ExecutionEvent)event;
            this.onExecutionEvent(executionEvent);
            if (ExecutionEvent.Type.SessionEnded.equals((Object)executionEvent.getType())) {
                Utils.writeMessage(new DefaultProjectModuleMessage(ProjectModuleBuilder.build(executionEvent.getSession(), this.context, this.resolvedDependencies)), null, LifecycleExecutionException.class, LifecycleExecutionExceptionMixin.class);
            }
        } else if (event instanceof DependencyResolutionResult) {
            DependencyResolutionResult resolutionResult = (DependencyResolutionResult)event;
            this.resolvedDependencies.put(resolutionResult.getDependencyGraph().getArtifact(), resolutionResult);
        }
    }

    private void onExecutionEvent(@Nonnull ExecutionEvent event) {
        DefaultEventMessage e;
        MavenProject project = event.getProject();
        String projectId = ProjectModuleBuilderUtils.computeName(project);
        MojoExecution mojoExec = event.getMojoExecution();
        if (project != null) {
            LinkedList<MavenProject> queue = new LinkedList<MavenProject>();
            queue.add(project);
            while (!queue.isEmpty()) {
                MavenProject p = (MavenProject)queue.poll();
                this.allProjects.add(p);
                queue.addAll(p.getCollectedProjects());
            }
        }
        if (mojoExec == null) {
            return;
        }
        String goal = mojoExec.getGoal();
        switch (event.getType()) {
            case ProjectDiscoveryStarted: 
            case ProjectStarted: 
            case MojoStarted: 
            case ForkStarted: 
            case ForkedProjectStarted: {
                e = new DefaultEventMessage(projectId, goal, null, State.STARTED);
                break;
            }
            case ProjectSucceeded: 
            case MojoSucceeded: 
            case ForkSucceeded: 
            case ForkedProjectSucceeded: {
                e = new DefaultEventMessage(projectId, goal, null, State.SUCCESS);
                break;
            }
            case ProjectSkipped: 
            case MojoSkipped: {
                e = new DefaultEventMessage(projectId, goal, null, State.SKIPPED);
                break;
            }
            case ProjectFailed: 
            case MojoFailed: 
            case ForkFailed: 
            case ForkedProjectFailed: {
                e = new DefaultEventMessage(projectId, goal, event.getException(), State.ERROR);
                break;
            }
            default: {
                e = new DefaultEventMessage(projectId, goal, null, State.UNKNOWN);
            }
        }
        Utils.writeMessage(e, null);
    }

    public void close() throws Exception {
        super.close();
        this.allProjects.stream().filter(p -> p.getId() != null).map(p -> new ProjectInfoMessage(p.getGroupId() + ":" + p.getArtifactId(), p.getCompileSourceRoots().stream().map(File::new).collect(Collectors.toList()), p.getTestCompileSourceRoots().stream().map(File::new).collect(Collectors.toList()), p.getBasedir())).forEach(message -> Utils.writeMessage(message, null));
    }
}

