/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.model;

import com.diffblue.cover.buildsystem.model.DefaultProjectModule;
import com.diffblue.cover.buildsystem.model.Plugin;
import com.diffblue.cover.buildsystem.model.ProjectModule;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DefaultProjectModuleBuilder {
    @Nullable
    private List<String> junitReportDirectories;
    @Nullable
    private List<String> jacocoReportDirectories;
    @Nullable
    private List<String> jacocoDestFile;
    @Nullable
    private List<String> jacocoFormats;
    private boolean isJacocoSkipped;
    @Nullable
    private List<File> runtimeClasspath;
    @Nullable
    private String javaComplianceLevel;
    @Nullable
    private List<File> productionSourceDirectories;
    @Nullable
    private List<File> testSourceDirectories;
    @Nullable
    private File productionClasses;
    @Nullable
    private File testClasses;
    @Nullable
    private Map<File, File> productionSourceToBuildPathMap;
    @Nullable
    private Map<File, File> testSourceToBuildPathMap;
    @Nullable
    private File buildDirectory;
    @Nullable
    private List<Plugin> activePlugins;
    @Nullable
    private String buildSystemVersion;
    @Nullable
    private String encoding;
    @Nullable
    private String buildSystemName;
    @Nullable
    private List<DefaultProjectModuleBuilder> subModules;
    @Nullable
    private String fullModuleName;
    @Nullable
    private String simpleModuleName;
    @Nullable
    private String parent;
    @Nullable
    private File location;

    public DefaultProjectModuleBuilder copy() {
        DefaultProjectModuleBuilder result = new DefaultProjectModuleBuilder();
        result.setJunitReportDirectories((List<String>)(this.junitReportDirectories == null ? null : new LinkedList<String>(this.junitReportDirectories)));
        result.setJacocoDestFile(this.jacocoDestFile);
        result.setJacocoFormats((List<String>)(this.jacocoFormats == null ? null : new LinkedList<String>(this.jacocoFormats)));
        result.setIsJacocoSkipped(this.isJacocoSkipped);
        result.setRuntimeClasspath((List<File>)(this.runtimeClasspath == null ? null : new LinkedList<File>(this.runtimeClasspath)));
        result.setJavaComplianceLevel(this.javaComplianceLevel);
        result.setProductionSourceDirectories((List<File>)(this.productionSourceDirectories == null ? null : new LinkedList<File>(this.productionSourceDirectories)));
        result.setTestSourceDirectories((List<File>)(this.testSourceDirectories == null ? null : new LinkedList<File>(this.testSourceDirectories)));
        result.setProductionClasses(this.productionClasses);
        result.setTestClasses(this.testClasses);
        result.setProductionSourceToBuildPathMap(this.productionSourceToBuildPathMap);
        result.setTestSourceToBuildPathMap(this.testSourceToBuildPathMap);
        result.setBuildDirectory(this.buildDirectory);
        result.setActivePlugins((List<Plugin>)(this.activePlugins == null ? null : new LinkedList<Plugin>(this.activePlugins)));
        result.setBuildSystemVersion(this.buildSystemVersion);
        result.setEncoding(this.encoding);
        result.setBuildSystemName(this.buildSystemName);
        result.setSubModules((List<DefaultProjectModuleBuilder>)(this.subModules == null ? null : new LinkedList<DefaultProjectModuleBuilder>(this.subModules)));
        result.setFullName(this.fullModuleName);
        result.setSimpleName(this.simpleModuleName);
        result.setParent(this.parent);
        result.setLocation(this.location);
        return result;
    }

    public DefaultProjectModuleBuilder setJunitReportDirectories(@Nullable List<String> junitReportDirectories) {
        this.junitReportDirectories = junitReportDirectories;
        return this;
    }

    public DefaultProjectModuleBuilder setJacocoReportDirectories(@Nullable List<String> jacocoReportDirectories) {
        this.jacocoReportDirectories = jacocoReportDirectories;
        return this;
    }

    public DefaultProjectModuleBuilder setJacocoDestFile(@Nullable List<String> jacocoDestFile) {
        this.jacocoDestFile = jacocoDestFile;
        return this;
    }

    public DefaultProjectModuleBuilder setJacocoFormats(@Nullable List<String> jacocoFormats) {
        this.jacocoFormats = jacocoFormats;
        return this;
    }

    public DefaultProjectModuleBuilder setIsJacocoSkipped(boolean isJacocoSkipped) {
        this.isJacocoSkipped = isJacocoSkipped;
        return this;
    }

    public DefaultProjectModuleBuilder setRuntimeClasspath(@Nullable List<File> runtimeClasspath) {
        this.runtimeClasspath = runtimeClasspath;
        return this;
    }

    public DefaultProjectModuleBuilder setJavaComplianceLevel(@Nullable String javaComplianceLevel) {
        this.javaComplianceLevel = javaComplianceLevel;
        return this;
    }

    public DefaultProjectModuleBuilder setProductionSourceDirectories(@Nullable List<File> productionSourceDirectories) {
        this.productionSourceDirectories = productionSourceDirectories;
        return this;
    }

    public DefaultProjectModuleBuilder setTestSourceDirectories(@Nullable List<File> testSourceDirectories) {
        this.testSourceDirectories = testSourceDirectories;
        return this;
    }

    public DefaultProjectModuleBuilder setProductionClasses(@Nullable File productionClasses) {
        this.productionClasses = productionClasses;
        return this;
    }

    public DefaultProjectModuleBuilder setTestClasses(@Nullable File testClasses) {
        this.testClasses = testClasses;
        return this;
    }

    public DefaultProjectModuleBuilder setTestSourceToBuildPathMap(@Nullable Map<File, File> testSourceToBuildPathMap) {
        this.testSourceToBuildPathMap = testSourceToBuildPathMap;
        return this;
    }

    public DefaultProjectModuleBuilder setProductionSourceToBuildPathMap(@Nullable Map<File, File> productionSourceToBuildPathMap) {
        this.productionSourceToBuildPathMap = productionSourceToBuildPathMap;
        return this;
    }

    public DefaultProjectModuleBuilder setBuildDirectory(@Nullable File buildDirectory) {
        this.buildDirectory = buildDirectory;
        return this;
    }

    public DefaultProjectModuleBuilder setActivePlugins(@Nullable List<Plugin> activePlugins) {
        this.activePlugins = activePlugins;
        return this;
    }

    public DefaultProjectModuleBuilder setBuildSystemVersion(@Nullable String buildSystemVersion) {
        this.buildSystemVersion = buildSystemVersion;
        return this;
    }

    public DefaultProjectModuleBuilder setEncoding(@Nullable String encoding) {
        this.encoding = encoding;
        return this;
    }

    public DefaultProjectModuleBuilder setBuildSystemName(@Nullable String buildSystemName) {
        this.buildSystemName = buildSystemName;
        return this;
    }

    public DefaultProjectModuleBuilder setSubModules(@Nullable List<DefaultProjectModuleBuilder> subModules) {
        this.subModules = subModules;
        return this;
    }

    public DefaultProjectModuleBuilder setFullName(@Nullable String name) {
        this.fullModuleName = name;
        return this;
    }

    public DefaultProjectModuleBuilder setSimpleName(@Nullable String simpleName) {
        this.simpleModuleName = simpleName;
        return this;
    }

    public DefaultProjectModuleBuilder setParent(@Nullable String parent) {
        this.parent = parent;
        return this;
    }

    public DefaultProjectModuleBuilder setLocation(@Nullable File location) {
        this.location = location;
        return this;
    }

    @Nullable
    public String getParent() {
        return this.parent;
    }

    @Nullable
    public String getName() {
        return this.fullModuleName;
    }

    @Nullable
    public String getSimpleName() {
        return this.simpleModuleName;
    }

    @Nullable
    public File getLocation() {
        return this.location;
    }

    @Nullable
    public List<DefaultProjectModuleBuilder> getSubModules() {
        return this.subModules;
    }

    public DefaultProjectModule build() {
        List<ProjectModule> subModules = this.subModules == null ? Collections.emptyList() : this.subModules.stream().map(DefaultProjectModuleBuilder::build).collect(Collectors.toList());
        return new DefaultProjectModule(this.junitReportDirectories, this.jacocoReportDirectories, this.jacocoDestFile, this.jacocoFormats, this.isJacocoSkipped, this.runtimeClasspath, this.javaComplianceLevel, this.productionSourceDirectories, this.testSourceDirectories, this.productionClasses, this.testClasses, this.productionSourceToBuildPathMap, this.testSourceToBuildPathMap, this.buildDirectory, this.activePlugins, this.buildSystemVersion, this.encoding, this.buildSystemName, subModules, this.fullModuleName, this.simpleModuleName, this.parent, this.location);
    }
}

