/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.gradle.plugin;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.logging.Logger;

class Safely {
    private final Logger logger;

    Safely(Logger logger) {
        this.logger = logger;
    }

    boolean runFirst(Runnable ... actions) {
        return this.getFirst((Supplier[])Stream.of(actions).map(RunnableSupplier::new).toArray(RunnableSupplier[]::new)).orElse(false);
    }

    @SafeVarargs
    final <Result> Optional<Result> getFirst(Supplier<Result> ... actions) {
        StackTraceElement caller = new Exception().getStackTrace()[1];
        for (int index = 0; index < actions.length; ++index) {
            Supplier<Result> supplier = actions[index];
            try {
                Result result = supplier.get();
                if (result == null) continue;
                return Optional.of(result);
            }
            catch (UnknownDomainObjectException e) {
                this.logger.debug("{} action #{}: {}", new Object[]{caller, index, e.getMessage()});
                continue;
            }
            catch (NoSuchMethodError e) {
                this.logger.debug("{} action #{} no such method: {}", new Object[]{caller, index, e.getMessage()});
            }
        }
        this.logger.debug("{} all {} actions failed", (Object)caller, (Object)actions.length);
        return Optional.empty();
    }

    private static class RunnableSupplier
    implements Supplier<Boolean> {
        private final Runnable action;

        RunnableSupplier(Runnable action) {
            this.action = action;
        }

        @Override
        public Boolean get() {
            this.action.run();
            return true;
        }
    }
}

