/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.platform.console.options.ClasspathEntriesConverter;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.options.Details;
import org.junit.platform.console.options.SelectorConverter;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.shadow.picocli.CommandLine;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UriSelector;

@CommandLine.Command(name="ConsoleLauncher", abbreviateSynopsis=true, sortOptions=false, usageHelpWidth=95, showAtFileInUsageHelp=true, usageHelpAutoWidth=true, description={"Launches the JUnit Platform for test discovery and execution."}, footerHeading="%n", footer={"For more information, please refer to the JUnit User Guide at%n@|underline https://junit.org/junit5/docs/current/user-guide/|@"})
class AvailableOptions {
    private static final String CP_OPTION = "cp";
    @CommandLine.ArgGroup(validate=false, order=1, heading="%n@|bold COMMANDS|@%n%n")
    CommandOptions commandOptions;
    @CommandLine.ArgGroup(validate=false, order=2, heading="%n@|bold SELECTORS|@%n%n")
    SelectorOptions selectorOptions;
    @CommandLine.ArgGroup(validate=false, order=3, heading="%n@|bold FILTERS|@%n%n")
    FilterOptions filterOptions;
    @CommandLine.ArgGroup(validate=false, order=4, heading="%n@|bold RUNTIME CONFIGURATION|@%n%n")
    RuntimeConfigurationOptions runtimeConfigurationOptions;
    @CommandLine.ArgGroup(validate=false, order=5, heading="%n@|bold REPORTING|@%n%n")
    ReportingOptions reportingOptions;
    @CommandLine.ArgGroup(validate=false, order=6, heading="%n@|bold CONSOLE OUTPUT|@%n%n")
    ConsoleOutputOptions consoleOutputOptions;

    AvailableOptions() {
    }

    CommandLine getParser() {
        CommandLine result = new CommandLine(this);
        result.setCaseInsensitiveEnumValuesAllowed(true);
        result.setAtFileCommentChar(null);
        return result;
    }

    CommandLineOptions toCommandLineOptions(CommandLine.ParseResult parseResult) {
        CommandLineOptions result = new CommandLineOptions();
        if (this.commandOptions != null) {
            this.commandOptions.applyTo(result);
        }
        if (this.selectorOptions != null) {
            this.selectorOptions.applyTo(parseResult, result);
        }
        if (this.filterOptions != null) {
            this.filterOptions.applyTo(result);
        }
        if (this.runtimeConfigurationOptions != null) {
            this.runtimeConfigurationOptions.applyTo(result);
        }
        if (this.reportingOptions != null) {
            this.reportingOptions.applyTo(result);
        }
        if (this.consoleOutputOptions != null) {
            this.consoleOutputOptions.applyTo(result);
        }
        return result;
    }

    private static <T> List<T> merge(List<T> list1, List<T> list2) {
        ArrayList<T> result = new ArrayList<T>(list1);
        result.addAll(list2);
        return result;
    }

    private static <T> T choose(T left, T right, T defaultValue) {
        return left == right ? left : (left == defaultValue ? right : left);
    }

    static class CommandOptions {
        @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Display help information."})
        private boolean helpRequested;
        @CommandLine.Option(names={"--h", "-help"}, help=true, hidden=true)
        private boolean helpRequested2;
        @CommandLine.Option(names={"--list-engines"}, description={"List all observable test engines."})
        private boolean listEnginesRequested;

        CommandOptions() {
        }

        private void applyTo(CommandLineOptions result) {
            result.setDisplayHelp(this.helpRequested || this.helpRequested2);
            result.setListEngines(this.listEnginesRequested);
        }
    }

    static class SelectorOptions {
        @CommandLine.Option(names={"--scan-classpath", "--scan-class-path"}, converter={ClasspathEntriesConverter.class}, paramLabel="PATH", arity="0..1", description={"Scan all directories on the classpath or explicit classpath roots. Without arguments, only directories on the system classpath as well as additional classpath entries supplied via -cp (directories and JAR files) are scanned. Explicit classpath roots that are not on the classpath will be silently ignored. This option can be repeated."})
        private List<Path> selectedClasspathEntries = new ArrayList<Path>();
        @CommandLine.Option(names={"-scan-class-path", "-scan-classpath"}, converter={ClasspathEntriesConverter.class}, arity="0..1", hidden=true)
        private List<Path> selectedClasspathEntries2 = new ArrayList<Path>();
        @CommandLine.Option(names={"--scan-modules"}, description={"EXPERIMENTAL: Scan all resolved modules for test discovery."})
        private boolean scanModulepath;
        @CommandLine.Option(names={"-scan-modules"}, hidden=true)
        private boolean scanModulepath2;
        @CommandLine.Option(names={"-u", "--select-uri"}, paramLabel="URI", arity="1", converter={SelectorConverter.Uri.class}, description={"Select a URI for test discovery. This option can be repeated."})
        private List<UriSelector> selectedUris = new ArrayList<UriSelector>();
        @CommandLine.Option(names={"--u", "-select-uri"}, arity="1", hidden=true, converter={SelectorConverter.Uri.class})
        private List<UriSelector> selectedUris2 = new ArrayList<UriSelector>();
        @CommandLine.Option(names={"-f", "--select-file"}, paramLabel="FILE", arity="1", converter={SelectorConverter.File.class}, description={"Select a file for test discovery. This option can be repeated."})
        private List<FileSelector> selectedFiles = new ArrayList<FileSelector>();
        @CommandLine.Option(names={"--f", "-select-file"}, arity="1", hidden=true, converter={SelectorConverter.File.class})
        private List<FileSelector> selectedFiles2 = new ArrayList<FileSelector>();
        @CommandLine.Option(names={"-d", "--select-directory"}, paramLabel="DIR", arity="1", converter={SelectorConverter.Directory.class}, description={"Select a directory for test discovery. This option can be repeated."})
        private List<DirectorySelector> selectedDirectories = new ArrayList<DirectorySelector>();
        @CommandLine.Option(names={"--d", "-select-directory"}, arity="1", hidden=true, converter={SelectorConverter.Directory.class})
        private List<DirectorySelector> selectedDirectories2 = new ArrayList<DirectorySelector>();
        @CommandLine.Option(names={"-o", "--select-module"}, paramLabel="NAME", arity="1", converter={SelectorConverter.Module.class}, description={"EXPERIMENTAL: Select single module for test discovery. This option can be repeated."})
        private List<ModuleSelector> selectedModules = new ArrayList<ModuleSelector>();
        @CommandLine.Option(names={"--o", "-select-module"}, arity="1", converter={SelectorConverter.Module.class}, hidden=true)
        private List<ModuleSelector> selectedModules2 = new ArrayList<ModuleSelector>();
        @CommandLine.Option(names={"-p", "--select-package"}, paramLabel="PKG", arity="1", converter={SelectorConverter.Package.class}, description={"Select a package for test discovery. This option can be repeated."})
        private List<PackageSelector> selectedPackages = new ArrayList<PackageSelector>();
        @CommandLine.Option(names={"--p", "-select-package"}, arity="1", hidden=true, converter={SelectorConverter.Package.class})
        private List<PackageSelector> selectedPackages2 = new ArrayList<PackageSelector>();
        @CommandLine.Option(names={"-c", "--select-class"}, paramLabel="CLASS", arity="1", converter={SelectorConverter.Class.class}, description={"Select a class for test discovery. This option can be repeated."})
        private List<ClassSelector> selectedClasses = new ArrayList<ClassSelector>();
        @CommandLine.Option(names={"--c", "-select-class"}, arity="1", hidden=true, converter={SelectorConverter.Class.class})
        private List<ClassSelector> selectedClasses2 = new ArrayList<ClassSelector>();
        @CommandLine.Option(names={"-m", "--select-method"}, paramLabel="NAME", arity="1", converter={SelectorConverter.Method.class}, description={"Select a method for test discovery. This option can be repeated."})
        private List<MethodSelector> selectedMethods = new ArrayList<MethodSelector>();
        @CommandLine.Option(names={"--m", "-select-method"}, arity="1", hidden=true, converter={SelectorConverter.Method.class})
        private List<MethodSelector> selectedMethods2 = new ArrayList<MethodSelector>();
        @CommandLine.Option(names={"-r", "--select-resource"}, paramLabel="RESOURCE", arity="1", converter={SelectorConverter.ClasspathResource.class}, description={"Select a classpath resource for test discovery. This option can be repeated."})
        private List<ClasspathResourceSelector> selectedClasspathResources = new ArrayList<ClasspathResourceSelector>();
        @CommandLine.Option(names={"--r", "-select-resource"}, arity="1", hidden=true, converter={SelectorConverter.ClasspathResource.class})
        private List<ClasspathResourceSelector> selectedClasspathResources2 = new ArrayList<ClasspathResourceSelector>();
        @CommandLine.Option(names={"-i", "--select-iteration"}, paramLabel="TYPE:VALUE[INDEX(..INDEX)?(,INDEX(..INDEX)?)*]", arity="1", converter={SelectorConverter.Iteration.class}, description={"Select iterations for test discovery (e.g. method:com.acme.Foo#m()[1..2]). This option can be repeated."})
        private List<IterationSelector> selectedIterations = new ArrayList<IterationSelector>();
        @CommandLine.Option(names={"--i", "-select-iteration"}, arity="1", hidden=true, converter={SelectorConverter.Iteration.class})
        private List<IterationSelector> selectedIterations2 = new ArrayList<IterationSelector>();

        SelectorOptions() {
        }

        private void applyTo(CommandLine.ParseResult parseResult, CommandLineOptions result) {
            result.setScanClasspath(parseResult.hasMatchedOption("scan-class-path"));
            result.setScanModulepath(this.scanModulepath || this.scanModulepath2);
            result.setSelectedModules(AvailableOptions.merge(this.selectedModules, this.selectedModules2));
            result.setSelectedClasspathEntries(AvailableOptions.merge(this.selectedClasspathEntries, this.selectedClasspathEntries2));
            result.setSelectedUris(AvailableOptions.merge(this.selectedUris, this.selectedUris2));
            result.setSelectedFiles(AvailableOptions.merge(this.selectedFiles, this.selectedFiles2));
            result.setSelectedDirectories(AvailableOptions.merge(this.selectedDirectories, this.selectedDirectories2));
            result.setSelectedPackages(AvailableOptions.merge(this.selectedPackages, this.selectedPackages2));
            result.setSelectedClasses(AvailableOptions.merge(this.selectedClasses, this.selectedClasses2));
            result.setSelectedMethods(AvailableOptions.merge(this.selectedMethods, this.selectedMethods2));
            result.setSelectedClasspathResources(AvailableOptions.merge(this.selectedClasspathResources, this.selectedClasspathResources2));
            result.setSelectedIterations(AvailableOptions.merge(this.selectedIterations, this.selectedIterations2));
        }
    }

    static class FilterOptions {
        @CommandLine.Option(names={"-n", "--include-classname"}, paramLabel="PATTERN", defaultValue="^(Test.*|.+[.$]Test.*|.*Tests?)$", arity="1", description={"Provide a regular expression to include only classes whose fully qualified names match. To avoid loading classes unnecessarily, the default pattern only includes class names that begin with \"Test\" or end with \"Test\" or \"Tests\". When this option is repeated, all patterns will be combined using OR semantics. Default: ${DEFAULT-VALUE}"})
        private List<String> includeClassNamePatterns = new ArrayList<String>();
        @CommandLine.Option(names={"--n", "-include-classname"}, arity="1", hidden=true)
        private List<String> includeClassNamePatterns2 = new ArrayList<String>();
        @CommandLine.Option(names={"-N", "--exclude-classname"}, paramLabel="PATTERN", arity="1", description={"Provide a regular expression to exclude those classes whose fully qualified names match. When this option is repeated, all patterns will be combined using OR semantics."})
        private List<String> excludeClassNamePatterns = new ArrayList<String>();
        @CommandLine.Option(names={"--N", "-exclude-classname"}, arity="1", hidden=true)
        private List<String> excludeClassNamePatterns2 = new ArrayList<String>();
        @CommandLine.Option(names={"--include-package"}, paramLabel="PKG", arity="1", description={"Provide a package to be included in the test run. This option can be repeated."})
        private List<String> includePackages = new ArrayList<String>();
        @CommandLine.Option(names={"-include-package"}, arity="1", hidden=true)
        private List<String> includePackages2 = new ArrayList<String>();
        @CommandLine.Option(names={"--exclude-package"}, paramLabel="PKG", arity="1", description={"Provide a package to be excluded from the test run. This option can be repeated."})
        private List<String> excludePackages = new ArrayList<String>();
        @CommandLine.Option(names={"-exclude-package"}, arity="1", hidden=true)
        private List<String> excludePackages2 = new ArrayList<String>();
        @CommandLine.Option(names={"-t", "--include-tag"}, paramLabel="TAG", arity="1", description={"Provide a tag or tag expression to include only tests whose tags match. When this option is repeated, all patterns will be combined using OR semantics."})
        private List<String> includedTags = new ArrayList<String>();
        @CommandLine.Option(names={"--t", "-include-tag"}, arity="1", hidden=true)
        private List<String> includedTags2 = new ArrayList<String>();
        @CommandLine.Option(names={"-T", "--exclude-tag"}, paramLabel="TAG", arity="1", description={"Provide a tag or tag expression to exclude those tests whose tags match. When this option is repeated, all patterns will be combined using OR semantics."})
        private List<String> excludedTags = new ArrayList<String>();
        @CommandLine.Option(names={"--T", "-exclude-tag"}, arity="1", hidden=true)
        private List<String> excludedTags2 = new ArrayList<String>();
        @CommandLine.Option(names={"-e", "--include-engine"}, paramLabel="ID", arity="1", description={"Provide the ID of an engine to be included in the test run. This option can be repeated."})
        private List<String> includedEngines = new ArrayList<String>();
        @CommandLine.Option(names={"--e", "-include-engine"}, arity="1", hidden=true)
        private List<String> includedEngines2 = new ArrayList<String>();
        @CommandLine.Option(names={"-E", "--exclude-engine"}, paramLabel="ID", arity="1", description={"Provide the ID of an engine to be excluded from the test run. This option can be repeated."})
        private List<String> excludedEngines = new ArrayList<String>();
        @CommandLine.Option(names={"--E", "-exclude-engine"}, arity="1", hidden=true)
        private List<String> excludedEngines2 = new ArrayList<String>();

        FilterOptions() {
        }

        private void applyTo(CommandLineOptions result) {
            result.setIncludedClassNamePatterns(AvailableOptions.merge(this.includeClassNamePatterns, this.includeClassNamePatterns2));
            result.setExcludedClassNamePatterns(AvailableOptions.merge(this.excludeClassNamePatterns, this.excludeClassNamePatterns2));
            result.setIncludedPackages(AvailableOptions.merge(this.includePackages, this.includePackages2));
            result.setExcludedPackages(AvailableOptions.merge(this.excludePackages, this.excludePackages2));
            result.setIncludedTagExpressions(AvailableOptions.merge(this.includedTags, this.includedTags2));
            result.setExcludedTagExpressions(AvailableOptions.merge(this.excludedTags, this.excludedTags2));
            result.setIncludedEngines(AvailableOptions.merge(this.includedEngines, this.includedEngines2));
            result.setExcludedEngines(AvailableOptions.merge(this.excludedEngines, this.excludedEngines2));
        }
    }

    static class RuntimeConfigurationOptions {
        @CommandLine.Option(names={"-cp", "--classpath", "--class-path"}, converter={ClasspathEntriesConverter.class}, paramLabel="PATH", arity="1", description={"Provide additional classpath entries -- for example, for adding engines and their dependencies. This option can be repeated."})
        private List<Path> additionalClasspathEntries = new ArrayList<Path>();
        @CommandLine.Option(names={"--cp", "-classpath", "-class-path"}, converter={ClasspathEntriesConverter.class}, hidden=true)
        private List<Path> additionalClasspathEntries2 = new ArrayList<Path>();
        private Map<String, String> configurationParameters = new LinkedHashMap<String, String>();
        @CommandLine.Spec
        private CommandLine.Model.CommandSpec spec;

        RuntimeConfigurationOptions() {
        }

        @CommandLine.Option(names={"-config"}, arity="1", hidden=true)
        public void setConfigurationParameters2(Map<String, String> keyValuePairs) {
            this.setConfigurationParameters(keyValuePairs);
        }

        @CommandLine.Option(names={"--config"}, paramLabel="KEY=VALUE", arity="1", description={"Set a configuration parameter for test discovery and execution. This option can be repeated."})
        public void setConfigurationParameters(Map<String, String> map) {
            for (String key : map.keySet()) {
                String newValue = map.get(key);
                this.validateUnique(key, newValue);
                this.configurationParameters.put(key, newValue);
            }
        }

        private void validateUnique(String key, String newValue) {
            String existing = this.configurationParameters.get(key);
            if (existing != null && !existing.equals(newValue)) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), String.format("Duplicate key '%s' for values '%s' and '%s'.", key, existing, newValue));
            }
        }

        private void applyTo(CommandLineOptions result) {
            result.setAdditionalClasspathEntries(AvailableOptions.merge(this.additionalClasspathEntries, this.additionalClasspathEntries2));
            result.setConfigurationParameters(this.configurationParameters);
        }
    }

    static class ReportingOptions {
        @CommandLine.Option(names={"--fail-if-no-tests"}, description={"Fail and return exit status code 2 if no tests are found."})
        private boolean failIfNoTests;
        @CommandLine.Option(names={"--reports-dir"}, paramLabel="DIR", description={"Enable report output into a specified local directory (will be created if it does not exist)."})
        private Path reportsDir;
        @CommandLine.Option(names={"-reports-dir"}, hidden=true)
        private Path reportsDir2;

        ReportingOptions() {
        }

        private void applyTo(CommandLineOptions result) {
            result.setFailIfNoTests(this.failIfNoTests);
            result.setReportsDir((Path)AvailableOptions.choose(this.reportsDir, this.reportsDir2, null));
        }
    }

    static class ConsoleOutputOptions {
        @CommandLine.Option(names={"--disable-ansi-colors"}, description={"Disable ANSI colors in output (not supported by all terminals)."})
        private boolean disableAnsiColors;
        @CommandLine.Option(names={"-disable-ansi-colors"}, hidden=true)
        private boolean disableAnsiColors2;
        @CommandLine.Option(names={"--color-palette"}, paramLabel="FILE", description={"Specify a path to a properties file to customize ANSI style of output (not supported by all terminals)."})
        private Path colorPalette;
        @CommandLine.Option(names={"-color-palette"}, hidden=true)
        private Path colorPalette2;
        @CommandLine.Option(names={"--single-color"}, description={"Style test output using only text attributes, no color (not supported by all terminals)."})
        private boolean singleColorPalette;
        @CommandLine.Option(names={"-single-color"}, hidden=true)
        private boolean singleColorPalette2;
        @CommandLine.Option(names={"--disable-banner"}, description={"Disable print out of the welcome message."})
        private boolean disableBanner;
        @CommandLine.Option(names={"-disable-banner"}, hidden=true)
        private boolean disableBanner2;
        @CommandLine.Option(names={"--details"}, paramLabel="MODE", defaultValue="tree", description={"Select an output details mode for when tests are executed. Use one of: ${COMPLETION-CANDIDATES}. If 'none' is selected, then only the summary and test failures are shown. Default: ${DEFAULT-VALUE}."})
        private Details details = CommandLineOptions.DEFAULT_DETAILS;
        @CommandLine.Option(names={"-details"}, hidden=true, defaultValue="tree")
        private Details details2 = CommandLineOptions.DEFAULT_DETAILS;
        @CommandLine.Option(names={"--details-theme"}, paramLabel="THEME", description={"Select an output details tree theme for when tests are executed. Use one of: ${COMPLETION-CANDIDATES}. Default is detected based on default character encoding."})
        private Theme theme = CommandLineOptions.DEFAULT_THEME;
        @CommandLine.Option(names={"-details-theme"}, hidden=true)
        private Theme theme2 = CommandLineOptions.DEFAULT_THEME;

        ConsoleOutputOptions() {
        }

        private void applyTo(CommandLineOptions result) {
            result.setAnsiColorOutputDisabled(this.disableAnsiColors || this.disableAnsiColors2);
            result.setColorPalettePath((Path)AvailableOptions.choose(this.colorPalette, this.colorPalette2, null));
            result.setSingleColorPalette(this.singleColorPalette || this.singleColorPalette2);
            result.setBannerDisabled(this.disableBanner || this.disableBanner2);
            result.setDetails((Details)((Object)AvailableOptions.choose((Object)this.details, (Object)this.details2, (Object)CommandLineOptions.DEFAULT_DETAILS)));
            result.setTheme((Theme)((Object)AvailableOptions.choose((Object)this.theme, (Object)this.theme2, (Object)CommandLineOptions.DEFAULT_THEME)));
        }
    }
}

