/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.fuzztest.shared.proxy.spring;

import java.util.Collections;
import java.util.List;

public final class BeanClassInfo {
    private final Class<?> clazz;
    private final List<BeanClassInfo> genericParameters;

    public BeanClassInfo(Class<?> clazz) {
        this(clazz, Collections.emptyList());
    }

    public BeanClassInfo(Class<?> clazz, List<BeanClassInfo> genericParameters) {
        this.clazz = clazz;
        this.genericParameters = genericParameters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.toString().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClassName());
        if (this.isGeneric()) {
            String sep = "";
            sb.append("<");
            for (BeanClassInfo info : this.genericParameters) {
                sb.append(sep);
                sep = ", ";
                sb.append(info.toString());
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public List<BeanClassInfo> getGenericParameters() {
        return this.genericParameters;
    }

    public boolean isGeneric() {
        return this.genericParameters != null && !this.genericParameters.isEmpty();
    }

    public String getClassName() {
        return this.clazz.getName();
    }

    public String getSimpleClassName() {
        return this.clazz.getSimpleName();
    }
}

