/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.fuzztest.shared;

import com.diffblue.fuzztest.shared.CriticalSection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClassLoadingCriticalSection {
    private static final ReadWriteLock classLoadingLock = new ReentrantReadWriteLock(true);

    public static CriticalSection acquireClassLoadingLock() {
        classLoadingLock.readLock().lock();
        return () -> classLoadingLock.readLock().unlock();
    }

    public static boolean tryAcquireExclusiveClassLoadingLock(long classLoaderLockTimeoutInMillis) throws InterruptedException {
        return classLoadingLock.writeLock().tryLock(classLoaderLockTimeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public static void releaseExclusiveClassLoadingLock() {
        classLoadingLock.writeLock().unlock();
    }
}

