/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.agent.defender;

public enum Capability {
    SYSTEM_EXIT("system.exit", "exiting the JVM"),
    SYSTEM_EXEC("system.exec", "executing a command"),
    SYSTEM_PRINT_JOB_ACCESS("system.print.job.access", "printing"),
    SYSTEM_LINK("system.link", "linking a library"),
    NETWORK_SOCKET_ACCEPT("network.socket.accept", "accepting network connections"),
    FILE_WRITE("file.write", "writing"),
    FILE_DELETE("file.delete", "deleting"),
    NETWORK_SOCKET_CONNECT("network.socket.connect", "connecting to a socket"),
    NETWORK_SOCKET_LISTEN("network.socket.listen", "listening for a connection"),
    NETWORK_MULTICAST("network.multicast", "creating, leaving, or joining a multicast group"),
    NETWORK_SOCKET_WRITE("network.socket.write", "writing to a socket"),
    UNSAFE_CALL("unsafe.call", "calling sun.misc.Unsafe methods"),
    MBEAN_CALL("mbean.call", "requesting MBeanPermission permission");

    private final String capability;
    private final String defaultReason;

    private Capability(String capability, String defaultReason) {
        this.capability = capability;
        this.defaultReason = defaultReason;
    }

    public static Capability getCapability(String value) {
        return Capability.valueOf(value.replace(".", "_").toUpperCase());
    }

    public String getDefaultReason() {
        return this.defaultReason;
    }

    public String toString() {
        return this.capability;
    }
}

