/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.agent.coverage;

import com.diffblue.cover.agent.coverage.EdgeCoverageRuntime;
import com.diffblue.cover.agent.coverage.RecordingFilter;

public class CoverageRuntime {
    private static boolean coverageEnabled = false;

    public static boolean isActive() {
        return coverageEnabled;
    }

    public static void enableCoverage(RecordingFilter recordingFilter) {
        EdgeCoverageRuntime.startRecording(recordingFilter);
        coverageEnabled = true;
    }

    public static void disableCoverage() {
        EdgeCoverageRuntime.stopRecording();
        coverageEnabled = false;
    }

    public static void reset() {
        EdgeCoverageRuntime.reset();
    }

    public static void onBasicBlockSpecialExit(Class<?> clazz) {
        if (coverageEnabled) {
            EdgeCoverageRuntime.onBasicBlockSpecialExit(clazz);
        }
    }

    public static void onBasicBlockHit(int basicBlockId, Class<?> clazz) {
        if (coverageEnabled) {
            EdgeCoverageRuntime.onBasicBlockHit(basicBlockId, clazz);
        }
    }

    public static void onCatchBlockEntry(int basicBlockId, int instructionNumber, Class<?> clazz) {
        if (coverageEnabled) {
            EdgeCoverageRuntime.onCatchBlockEntry(basicBlockId, instructionNumber, clazz);
        }
    }

    public static void onArtificialBranching(boolean positive, Class<?> blockClass) {
        if (coverageEnabled) {
            EdgeCoverageRuntime.onArtificialBranching(positive, blockClass);
        }
    }

    public static void ensureLoaded() {
        EdgeCoverageRuntime.ensureLoaded();
    }
}

