/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.agent;

import javax.annotation.Nullable;

public class ValueTrackingRuntime {
    private static ValueTrackerFactory valueTrackerFactory = NoOpValueTrackerFactory.INSTANCE;

    public static void setValueTrackerFactory(ValueTrackerFactory valueTrackerFactory) {
        ValueTrackingRuntime.valueTrackerFactory = valueTrackerFactory;
    }

    public static ValueTracker getValueTracker(int methodLabel) {
        ValueTracker valueTracker = valueTrackerFactory.make(methodLabel);
        return valueTracker == null ? NoOpValueTracker.INSTANCE : valueTracker;
    }

    public static void resetValueTrackerFactory() {
        valueTrackerFactory = NoOpValueTrackerFactory.INSTANCE;
    }

    public static interface ValueTrackerFactory {
        @Nullable
        public ValueTracker make(int var1);
    }

    public static interface ValueTracker {
        public void recordArgument(int var1, Object var2);

        default public void recordArgument(int index, boolean value) {
            this.recordArgument(index, (Object)value);
        }

        default public void recordArgument(int index, byte value) {
            this.recordArgument(index, (Object)value);
        }

        default public void recordArgument(int index, char value) {
            this.recordArgument(index, Character.valueOf(value));
        }

        default public void recordArgument(int index, short value) {
            this.recordArgument(index, (Object)value);
        }

        default public void recordArgument(int index, int value) {
            this.recordArgument(index, (Object)value);
        }

        default public void recordArgument(int index, long value) {
            this.recordArgument(index, (Object)value);
        }

        default public void recordArgument(int index, float value) {
            this.recordArgument(index, Float.valueOf(value));
        }

        default public void recordArgument(int index, double value) {
            this.recordArgument(index, (Object)value);
        }

        public void recordReturnValue(Object var1);

        default public void recordReturnValue(boolean value) {
            this.recordReturnValue((Object)value);
        }

        default public void recordReturnValue(byte value) {
            this.recordReturnValue((Object)value);
        }

        default public void recordReturnValue(char value) {
            this.recordReturnValue(Character.valueOf(value));
        }

        default public void recordReturnValue(short value) {
            this.recordReturnValue((Object)value);
        }

        default public void recordReturnValue(int value) {
            this.recordReturnValue((Object)value);
        }

        default public void recordReturnValue(long value) {
            this.recordReturnValue((Object)value);
        }

        default public void recordReturnValue(float value) {
            this.recordReturnValue(Float.valueOf(value));
        }

        default public void recordReturnValue(double value) {
            this.recordReturnValue((Object)value);
        }
    }

    private static class NoOpValueTracker
    implements ValueTracker {
        public static final NoOpValueTracker INSTANCE = new NoOpValueTracker();

        private NoOpValueTracker() {
        }

        @Override
        public void recordArgument(int index, Object value) {
        }

        @Override
        public void recordReturnValue(Object value) {
        }
    }

    static enum NoOpValueTrackerFactory implements ValueTrackerFactory
    {
        INSTANCE;


        @Override
        @Nullable
        public ValueTracker make(int methodLabel) {
            return null;
        }
    }
}

