/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.agent;

import java.io.Closeable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.HijrahChronology;
import java.time.chrono.HijrahDate;
import java.time.chrono.HijrahEra;
import java.time.chrono.JapaneseChronology;
import java.time.chrono.JapaneseDate;
import java.time.chrono.MinguoChronology;
import java.time.chrono.MinguoDate;
import java.time.chrono.ThaiBuddhistChronology;
import java.time.chrono.ThaiBuddhistDate;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class InjectedClockRuntime {
    private static final Clock SYSTEM_CLOCK = Clock.systemDefaultZone();
    private static final TimeZone SYSTEM_TIME_ZONE = TimeZone.getDefault();
    private static Clock injectedClock;

    public static void enable(Clock newClock) {
        injectedClock = newClock;
        TimeZone.setDefault(TimeZone.getTimeZone(newClock.getZone()));
    }

    public static void disable() {
        injectedClock = null;
        TimeZone.setDefault(SYSTEM_TIME_ZONE);
    }

    public static boolean isEnabled() {
        return injectedClock != null;
    }

    public static Clock getClock() {
        if (InjectedClockRuntime.isEnabled()) {
            return injectedClock;
        }
        return SYSTEM_CLOCK;
    }

    public static long getMillis() {
        return InjectedClockRuntime.getClock().millis();
    }

    public static Clock getClock(ZoneId zoneId) {
        return InjectedClockRuntime.getClock();
    }

    public static Instant getInstant() {
        return InjectedClockRuntime.getClock().instant();
    }

    public static LocalDate getLocalDate() {
        return LocalDate.now(InjectedClockRuntime.getClock());
    }

    public static LocalDate getLocalDate(ZoneId zoneId) {
        return LocalDate.now(InjectedClockRuntime.getClock());
    }

    public static LocalDateTime getLocalDateTime() {
        return LocalDateTime.now(InjectedClockRuntime.getClock());
    }

    public static LocalDateTime getLocalDateTime(ZoneId zoneId) {
        return LocalDateTime.now(InjectedClockRuntime.getClock());
    }

    public static LocalTime getLocalTime() {
        return LocalTime.now(InjectedClockRuntime.getClock());
    }

    public static LocalTime getLocalTime(ZoneId zoneId) {
        return LocalTime.now(InjectedClockRuntime.getClock());
    }

    public static ZoneId getZoneId() {
        return InjectedClockRuntime.getClock().getZone();
    }

    public static Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(InjectedClockRuntime.getDate());
        calendar.setTimeZone(TimeZone.getTimeZone(InjectedClockRuntime.getZoneId()));
        return calendar;
    }

    public static Date getDate() {
        return Date.from(InjectedClockRuntime.getInstant());
    }

    public static TimeZone getTimeZone() {
        return TimeZone.getTimeZone(InjectedClockRuntime.getZoneId());
    }

    public static JapaneseDate getJapaneseDate() {
        return JapaneseDate.now(InjectedClockRuntime.getClock());
    }

    public static JapaneseDate getJapaneseDate(JapaneseChronology ignored) {
        return JapaneseDate.now(InjectedClockRuntime.getClock());
    }

    public static GregorianCalendar getGregorianCalendar() {
        return GregorianCalendar.from(ZonedDateTime.of(InjectedClockRuntime.getLocalDateTime(), InjectedClockRuntime.getZoneId()));
    }

    public static JapaneseDate getJapaneseDate(ZoneId zoneId) {
        return JapaneseDate.now(InjectedClockRuntime.getClock());
    }

    public static JapaneseDate getJapaneseDate(JapaneseChronology ignored, ZoneId zoneId) {
        return JapaneseDate.now(InjectedClockRuntime.getClock());
    }

    public static GregorianCalendar getGregorianCalendar(Locale locale) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(InjectedClockRuntime.getTimeZone(), locale);
        gregorianCalendar.setTime(InjectedClockRuntime.getDate());
        return gregorianCalendar;
    }

    public static MinguoDate getMinguoDate() {
        return MinguoDate.now(InjectedClockRuntime.getClock());
    }

    public static MinguoDate getMinguoDate(MinguoChronology ignored) {
        return MinguoDate.now(InjectedClockRuntime.getClock());
    }

    public static GregorianCalendar getGregorianCalendar(TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTime(InjectedClockRuntime.getDate());
        return gregorianCalendar;
    }

    public static MinguoDate getMinguoDate(ZoneId zoneId) {
        return MinguoDate.now(InjectedClockRuntime.getClock());
    }

    public static MinguoDate getMinguoDate(MinguoChronology ignored, ZoneId zoneId) {
        return MinguoDate.now(InjectedClockRuntime.getClock());
    }

    public static ThaiBuddhistDate getThaiBuddhistDate() {
        return ThaiBuddhistDate.now(InjectedClockRuntime.getClock());
    }

    public static ThaiBuddhistDate getThaiBuddhistDate(ZoneId zoneId) {
        return ThaiBuddhistDate.now(InjectedClockRuntime.getClock());
    }

    public static ThaiBuddhistDate getThaiBuddhistDate(ThaiBuddhistChronology ignored) {
        return ThaiBuddhistDate.now(InjectedClockRuntime.getClock());
    }

    public static ThaiBuddhistDate getThaiBuddhistDate(ThaiBuddhistChronology ignored, ZoneId zoneId) {
        return ThaiBuddhistDate.now(InjectedClockRuntime.getClock());
    }

    public static GregorianCalendar getGregorianCalendar(TimeZone timeZone, Locale locale) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone, locale);
        gregorianCalendar.setTime(InjectedClockRuntime.getDate());
        return gregorianCalendar;
    }

    public static OffsetDateTime getOffsetDateTime() {
        return OffsetDateTime.now(InjectedClockRuntime.getClock());
    }

    public static OffsetDateTime getOffsetDateTime(ZoneId zoneId) {
        return OffsetDateTime.now(InjectedClockRuntime.getClock());
    }

    public static OffsetTime getOffsetTime() {
        return OffsetTime.now(InjectedClockRuntime.getClock());
    }

    public static OffsetTime getOffsetTime(ZoneId zoneId) {
        return OffsetTime.now(InjectedClockRuntime.getClock());
    }

    public static MonthDay getMonthDay() {
        return MonthDay.now(InjectedClockRuntime.getClock());
    }

    public static MonthDay getMonthDay(ZoneId zoneId) {
        return MonthDay.now(InjectedClockRuntime.getClock());
    }

    public static Year getYear() {
        return Year.now(InjectedClockRuntime.getClock());
    }

    public static Year getYear(ZoneId zoneId) {
        return Year.now(InjectedClockRuntime.getClock());
    }

    public static YearMonth getYearMonth() {
        return YearMonth.now(InjectedClockRuntime.getClock());
    }

    public static YearMonth getYearMonth(ZoneId zoneId) {
        return YearMonth.now(InjectedClockRuntime.getClock());
    }

    public static ZonedDateTime getZonedDateTime() {
        return ZonedDateTime.now(InjectedClockRuntime.getClock());
    }

    public static ZonedDateTime getZonedDateTime(ZoneId zoneId) {
        return ZonedDateTime.now(InjectedClockRuntime.getClock());
    }

    public static HijrahDate getDateWithHijrahChronology(HijrahChronology ignored) {
        return HijrahChronology.INSTANCE.dateNow(InjectedClockRuntime.getClock());
    }

    public static HijrahDate getDateWithHijrahChronology(HijrahChronology ignored, ZoneId zoneId) {
        return HijrahChronology.INSTANCE.dateNow(InjectedClockRuntime.getClock());
    }

    public static HijrahDate getHijrahDate() {
        return HijrahDate.now(InjectedClockRuntime.getClock());
    }

    public static HijrahDate getHijrahDate(ZoneId zoneId) {
        return HijrahDate.now(InjectedClockRuntime.getClock());
    }

    public static String getHijrahEraDisplayName(HijrahEra ignored, TextStyle textStyle, Locale locale) {
        return new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.ERA, textStyle).toFormatter(locale).withChronology(HijrahChronology.INSTANCE).format(HijrahDate.now(InjectedClockRuntime.getClock()));
    }

    public static class InjectedClock
    implements Closeable {
        private final Clock clock;

        public static InjectedClock observation() {
            return new InjectedClock(new FixedAdvancingClock(Instant.EPOCH, ZoneId.of("UTC"), Duration.ofNanos(111111111L)));
        }

        public static InjectedClock pastValidation() {
            return new InjectedClock(new FixedAdvancingClock(LocalDateTime.parse("2017-02-27T17:59:28").plusNanos(123456789L).plusMonths(6L).toInstant(ZoneOffset.UTC), ZoneId.of("-07:00"), Duration.ofNanos(555555555L)));
        }

        public static InjectedClock futureValidation() {
            return new InjectedClock(new FixedAdvancingClock(LocalDateTime.parse("9999-10-31T05:33:33").plusNanos(999999999L).toInstant(ZoneOffset.MAX), ZoneId.of("-18:00"), Duration.ofNanos(999999999L)));
        }

        private InjectedClock(Clock clock) {
            this.clock = clock;
            InjectedClockRuntime.enable(clock);
        }

        public Clock getClock() {
            return this.clock;
        }

        @Override
        public void close() {
            InjectedClockRuntime.disable();
        }
    }

    private static class FixedAdvancingClock
    extends Clock {
        private Instant instant;
        private final ZoneId zone;
        private final Duration advance;

        private FixedAdvancingClock(Instant instant, ZoneId zone, Duration advance) {
            this.instant = instant;
            this.zone = zone;
            this.advance = advance;
        }

        @Override
        public Clock withZone(ZoneId zone) {
            if (zone.equals(this.zone)) {
                return this;
            }
            return new FixedAdvancingClock(this.instant, zone, this.advance);
        }

        @Override
        public ZoneId getZone() {
            return this.zone;
        }

        @Override
        public Instant instant() {
            try {
                Instant instant = this.instant;
                return instant;
            }
            finally {
                this.instant = this.instant.plus(this.advance);
            }
        }

        public String toString() {
            return String.format("FixedAdvancingClock[instant=%s,zone=%s,advance=%s]", this.instant, this.zone, this.advance);
        }
    }
}

