/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.cover.buildsystem.maven.internal;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

public final class ProjectModuleBuilderUtils {
    private ProjectModuleBuilderUtils() {
    }

    public static List<File> computeDependencyList(@Nullable DependencyResolutionResult resolvedDependencies) {
        if (resolvedDependencies == null) {
            return Collections.emptyList();
        }
        PreorderNodeListGenerator listGenerator = new PreorderNodeListGenerator();
        resolvedDependencies.getDependencyGraph().accept((DependencyVisitor)listGenerator);
        return listGenerator.getDependencies(true).stream().map(Dependency::getArtifact).map(Artifact::getFile).collect(Collectors.toList());
    }

    public static String computeName(@Nullable MavenProject project) {
        if (project == null) {
            return null;
        }
        return project.getGroupId() + ":" + project.getArtifactId();
    }
}

