Instructions
============

These are the instructions to deploy and run Cover Reports.

By default, Cover Reports uses an embedded H2 database and **requires no configuration**.

It does require a JDK 11+ to be available on the path or with the `JAVA_HOME`
environment variable.

## Deployment

* execute the `bin/cover-reports` script for your operating system
  * `bin/cover-reports` for UN*X
  * `bin/cover-reports.bat` for Windows

## Configuration

Configuration is best done by setting property values in a properties file.

#### Setting properties in a file

The properties file must be called `application.properties` and must exist in the
directory where the wrapper scripts are **executed**.

An example **application.properties** file is provided with the important properties
commented. To set a property, simply uncomment the line and adjust the value as required.

#### Setting properties with environment variables

In cases where it is not possible to create an `application.properties` file, the properties
can be set as system environment variables. They will automatically get picked up when
running the wrapper scripts.

The names of the properties should be upper-cased and any `.` characters replaced with `_`
to align with standard environment variable syntax. For example:

```
spring.profiles.active => SPRING_PROFILES_ACTIVE
spring.datasource.url => SPRING_DATASOURCE_URL
spring.datasource.username => SPRING_DATASOURCE_USERNAME
spring.datasource.password => SPRING_DATASOURCE_PASSWORD
```

#### Changing the location of the properties file

The name and location of the `application.properties` file can be configured using an
environment variable. This can be useful when [running as a service](#running-as-a-service)
or where the properties need to be stored in a specific location.

Set `SPRING_CONFIG_ADDITIONALLOCATION` to the new path. For example, on a linux system:

```bash
export SPRING_CONFIG_ADDITIONALLOCATION=file:<PROPERTIES-PATH>/application.properties
```

## Changing the network port

By default, Cover Reports listens on port 8080.

If this port already has a service attached, Cover Reports will fail to start and indicate
this is the problem.

To change the port, add a property to the [application.properties](#creating-an-applicationproperties-file)
file as described above. The property is:

```properties
server.port=8081
```

## Changing the H2 database files location

By default, the H2 database writes files into the directory in which Cover Reports is started.

In this example on a linux system, the H2 database files are created in the
`cover-reports/bin/` folder.

```bash
$ cd ./cover-reports/bin/
$ ./cover-reports
$ ls *.db
cover-reports-db.mv.db
```

To change this, add a property to the [application.properties](#creating-an-applicationproperties-file)
file as described above. The property is:

```properties
reports.h2.path=/path/to/database/files
```

> N.B. No trailing / character is required!

## Using an external database server

Currently, only [PostgreSQL](https://www.postgresql.org/) is supported.

To use this database server:

* A new database and user must be created on the database server
* Cover Reports must be [configured](#configuration) to use the new database

#### Creating a new database and user

There are several steps to achieve this:

* Create a Reports database in the Postgres installation
* Create a user for this database
* Grant all privileges on the new database to the new user

This can be done by logging into the database server using a GUI tool or using
[psql](https://www.postgresql.org/docs/current/app-psql.html#:~:text=psql%20is%20a%20terminal%2Dbased,and%20see%20the%20query%20results.)

Here is an example set of commands to run:

```psql
create database reports;

-- change <REPORTS-DB-PASSWORD> for your own password
create user reports with encrypted password <REPORTS-DB-PASSWORD>;

grant all privileges on database reports to reports;
```

#### Configuring Cover Reports

Cover Reports must be configured to point to this new database.

Here is an example set of properties based on the PSQL script run above:

```properties
spring.profiles.active=postgres
spring.datasource.url=jdbc:postgresql://localhost:5432/reports
spring.datasource.username=reports
spring.datasource.password=<REPORTS-DB-PASSWORD>
```

> N.B. The `localhost:5432` part of `spring.datasource.url` must be substituted with the
> host and port of the database server respectively

## Running as a service

Cover Reports can be run as a service. The way this is configured depends on the host OS.

This installation provides templates for each supported OS.

> When running as a service, the configuration should be done using
> [environment variables](#setting-properties-with-environment-variables)

#### Linux (systemd)

To install on a Linux host that uses `systemd`, the required configuration file is in the
`systemd-service` folder.

Prior to use, the [configuration file](./systemd-service/cover-reports.service) must be adjusted to account for:

* the path of the installation on the host
* the path where the H2 database files should be configured
* the path where the cover-reports log file should be created
* the user that will own the process - the template uses `cover-reports` which may need to be created.

Then the service file can be used as normal, i.e. with
[systemctl](https://www.redhat.com/sysadmin/linux-systemctl-manage-services)

#### Windows

To install on a Windows host, the required configuration files are in the
`windows-service` folder.

Prior to installation, the [configuration file](./windows-service/cover-reports.xml) must
be adjusted to account for the path of the installation on the host and the path to JAVA.

To install:

* open a terminal
* navigate into the `windows-service` folder
* execute: `cover-reports.exe install`

To start the service:

* execute: `cover-reports.exe start`

To stop the service:

* execute: `cover-reports.exe stop`

To uninstall the service:

* execute: `cover-reports.exe uninstall`

> Once the service has been installed it can be accessed using the Windows Service Manager

----

Copyright 2023 Diffblue Limited. All Rights Reserved.
Unpublished proprietary source code.
Use is governed by https://docs.diffblue.com/licenses/eula
